/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.store.compressor;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.bifromq.basecrdt.store.compressor.Compressor;

public class GzipCompressor
implements Compressor {
    @Override
    public ByteString compress(ByteString src) {
        ByteString.Output out = ByteString.newOutput();
        try (GZIPOutputStream defl = new GZIPOutputStream((OutputStream)out);
             InputStream is = src.newInput();){
            is.transferTo(defl);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteString();
    }

    @Override
    public ByteString decompress(ByteString src) {
        ByteString.Output out = ByteString.newOutput();
        try (GZIPInputStream infl = new GZIPInputStream(src.newInput());){
            infl.transferTo((OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteString();
    }
}

