/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class BrowseNextRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=531");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=533");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=532");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15186");
    private final RequestHeader requestHeader;
    private final Boolean releaseContinuationPoints;
    private final ByteString[] continuationPoints;

    public BrowseNextRequest(RequestHeader requestHeader, Boolean releaseContinuationPoints, ByteString[] continuationPoints) {
        this.requestHeader = requestHeader;
        this.releaseContinuationPoints = releaseContinuationPoints;
        this.continuationPoints = continuationPoints;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public Boolean getReleaseContinuationPoints() {
        return this.releaseContinuationPoints;
    }

    public ByteString[] getContinuationPoints() {
        return this.continuationPoints;
    }

    protected BrowseNextRequest(BrowseNextRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((BrowseNextRequestBuilder)b).requestHeader;
        this.releaseContinuationPoints = ((BrowseNextRequestBuilder)b).releaseContinuationPoints;
        this.continuationPoints = ((BrowseNextRequestBuilder)b).continuationPoints;
    }

    public static BrowseNextRequestBuilder<?, ?> builder() {
        return new BrowseNextRequestBuilderImpl();
    }

    public BrowseNextRequestBuilder<?, ?> toBuilder() {
        return new BrowseNextRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrowseNextRequest)) {
            return false;
        }
        BrowseNextRequest other = (BrowseNextRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$releaseContinuationPoints = this.getReleaseContinuationPoints();
        Boolean other$releaseContinuationPoints = other.getReleaseContinuationPoints();
        if (this$releaseContinuationPoints == null ? other$releaseContinuationPoints != null : !((Object)this$releaseContinuationPoints).equals(other$releaseContinuationPoints)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        return Arrays.deepEquals(this.getContinuationPoints(), other.getContinuationPoints());
    }

    protected boolean canEqual(Object other) {
        return other instanceof BrowseNextRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $releaseContinuationPoints = this.getReleaseContinuationPoints();
        result = result * 59 + ($releaseContinuationPoints == null ? 43 : ((Object)$releaseContinuationPoints).hashCode());
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getContinuationPoints());
        return result;
    }

    @Override
    public String toString() {
        return "BrowseNextRequest(requestHeader=" + this.getRequestHeader() + ", releaseContinuationPoints=" + this.getReleaseContinuationPoints() + ", continuationPoints=" + Arrays.deepToString(this.getContinuationPoints()) + ")";
    }

    private static final class BrowseNextRequestBuilderImpl
    extends BrowseNextRequestBuilder<BrowseNextRequest, BrowseNextRequestBuilderImpl> {
        private BrowseNextRequestBuilderImpl() {
        }

        @Override
        protected BrowseNextRequestBuilderImpl self() {
            return this;
        }

        @Override
        public BrowseNextRequest build() {
            return new BrowseNextRequest(this);
        }
    }

    public static abstract class BrowseNextRequestBuilder<C extends BrowseNextRequest, B extends BrowseNextRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private Boolean releaseContinuationPoints;
        private ByteString[] continuationPoints;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BrowseNextRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(BrowseNextRequest instance, BrowseNextRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.releaseContinuationPoints(instance.releaseContinuationPoints);
            b.continuationPoints(instance.continuationPoints);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B releaseContinuationPoints(Boolean releaseContinuationPoints) {
            this.releaseContinuationPoints = releaseContinuationPoints;
            return (B)this.self();
        }

        public B continuationPoints(ByteString[] continuationPoints) {
            this.continuationPoints = continuationPoints;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "BrowseNextRequest.BrowseNextRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", releaseContinuationPoints=" + this.releaseContinuationPoints + ", continuationPoints=" + Arrays.deepToString(this.continuationPoints) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<BrowseNextRequest> {
        @Override
        public Class<BrowseNextRequest> getType() {
            return BrowseNextRequest.class;
        }

        @Override
        public BrowseNextRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            Boolean releaseContinuationPoints = decoder.readBoolean("ReleaseContinuationPoints");
            ByteString[] continuationPoints = decoder.readByteStringArray("ContinuationPoints");
            return new BrowseNextRequest(requestHeader, releaseContinuationPoints, continuationPoints);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, BrowseNextRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeBoolean("ReleaseContinuationPoints", value.getReleaseContinuationPoints());
            encoder.writeByteStringArray("ContinuationPoints", value.getContinuationPoints());
        }
    }
}

