/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription.payload;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum SubscriptionMessageType {
    SESSION_DATA_SETS_HANDLER(0),
    TS_FILE_HANDLER(1);

    private final short type;
    private static final Map<Short, SubscriptionMessageType> TYPE_MAP;

    private SubscriptionMessageType(short type) {
        this.type = type;
    }

    public short getType() {
        return this.type;
    }

    public static boolean isValidatedMessageType(short type) {
        return TYPE_MAP.containsKey(type);
    }

    public static SubscriptionMessageType valueOf(short type) {
        return TYPE_MAP.get(type);
    }

    static {
        TYPE_MAP = Arrays.stream(SubscriptionMessageType.values()).collect(HashMap::new, (typeMap, messageType) -> typeMap.put(messageType.getType(), messageType), HashMap::putAll);
    }
}

