/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array;

import java.util.HashMap;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.ObjectBigArray;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.TsPrimitiveType;

public final class MapBigArray {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(MapBigArray.class);
    private final ObjectBigArray<HashMap<TsPrimitiveType, Long>> array = new ObjectBigArray();
    private long sizeOfMaps;

    public long sizeOf() {
        return INSTANCE_SIZE + this.array.sizeOf() + this.sizeOfMaps;
    }

    public HashMap<TsPrimitiveType, Long> get(long index) {
        HashMap<Object, Long> result = this.array.get(index);
        if (result == null) {
            result = new HashMap();
            this.array.set(index, result);
        }
        return result;
    }

    public void set(long index, HashMap<TsPrimitiveType, Long> value) {
        this.updateRetainedSize(index, value);
        this.array.set(index, value);
    }

    public void ensureCapacity(long length) {
        this.array.ensureCapacity(length);
    }

    private void updateRetainedSize(long index, HashMap<TsPrimitiveType, Long> value) {
        HashMap<TsPrimitiveType, Long> currentValue = this.array.get(index);
        if (currentValue != null) {
            this.sizeOfMaps -= RamUsageEstimator.sizeOfObject(currentValue);
        }
        if (value != null) {
            this.sizeOfMaps += RamUsageEstimator.sizeOfObject(value);
        }
    }

    public void reset() {
        this.array.forEach(v -> {
            if (v != null) {
                v.clear();
            }
        });
    }
}

