/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.canon;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import org.apache.james.jdkim.canon.AbstractOutputStreamTestCase;
import org.apache.james.jdkim.canon.CompoundOutputStream;

public class CompoundOutputStreamTest
extends AbstractOutputStreamTestCase {
    private byte[] testData;

    protected void setUp() throws Exception {
        this.testData = new byte[4096];
        for (int i = 0; i < this.testData.length; ++i) {
            this.testData[i] = (byte)((i * i * 4095 + (this.testData.length - i) * 17) % 128);
        }
    }

    public void testSingleBytes() throws NoSuchAlgorithmException, IOException {
        LinkedList<ByteArrayOutputStream> oss = new LinkedList<ByteArrayOutputStream>();
        for (int i = 0; i < 5; ++i) {
            oss.add(new ByteArrayOutputStream());
        }
        CompoundOutputStream os = new CompoundOutputStream(oss);
        for (byte aTestData : this.testData) {
            os.write((int)aTestData);
        }
        os.close();
        Object object = oss.iterator();
        while (object.hasNext()) {
            ByteArrayOutputStream bos = (ByteArrayOutputStream)object.next();
            this.assertArrayEquals(this.testData, bos.toByteArray());
        }
    }

    public void testChunks() throws NoSuchAlgorithmException, IOException {
        LinkedList<ByteArrayOutputStream> oss = new LinkedList<ByteArrayOutputStream>();
        for (int i = 0; i < 5; ++i) {
            oss.add(new ByteArrayOutputStream());
        }
        CompoundOutputStream os = new CompoundOutputStream(oss);
        this.chunker(this.testData, (OutputStream)os);
        for (ByteArrayOutputStream bos : oss) {
            this.assertArrayEquals(this.testData, bos.toByteArray());
        }
    }
}

