/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.base.file;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.dboe.DBOpEnvException;
import org.apache.jena.dboe.base.file.AlreadyLocked;
import org.apache.jena.dboe.sys.ProcessUtils;

public class ProcessFileLock {
    private static Object sync = new Object();
    private static ConcurrentHashMap<Path, ProcessFileLock> locks = new ConcurrentHashMap();
    private final Path filepath;
    private final FileChannel fileChannel;
    private FileLock fileLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearLocksProcessState() {
        Object object = sync;
        synchronized (object) {
            try {
                locks.forEach((path, lock) -> lock.free());
                locks.clear();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static ProcessFileLock create(String filename) {
        try {
            Path abspath = Path.of(filename, new String[0]).toRealPath(new LinkOption[0]);
            return locks.computeIfAbsent(abspath, ProcessFileLock::new);
        }
        catch (IOException e) {
            IO.exception((IOException)e);
            return null;
        }
    }

    public static void release(ProcessFileLock lockFile) {
        if (lockFile == null) {
            return;
        }
        locks.remove(lockFile.getPath());
        lockFile.free();
    }

    private ProcessFileLock(Path filename) {
        try {
            this.filepath = filename;
            this.fileChannel = FileChannel.open(filename, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.DSYNC);
            this.fileLock = null;
        }
        catch (FileNotFoundException | NoSuchFileException ex) {
            throw new RuntimeIOException("No such file '" + String.valueOf(filename) + "'", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new RuntimeIOException("Failed to open '" + String.valueOf(filename) + "'", (Throwable)ex);
        }
    }

    public void lockEx() {
        this.lockOperation(NoLockAction.EXCEPTION);
    }

    public void lockWait() {
        this.lockOperation(NoLockAction.WAIT);
    }

    public boolean tryLock() {
        return this.lockOperation(NoLockAction.RETURN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        Object object = sync;
        synchronized (object) {
            if (this.fileLock == null) {
                throw new IllegalStateException("unlock not paired with a lock call");
            }
            try {
                this.fileLock.release();
            }
            catch (IOException ex) {
                throw new RuntimeIOException("Failed to unlock '" + String.valueOf(this.filepath) + "'", (Throwable)ex);
            }
        }
    }

    public boolean isLockedHere() {
        if (this.fileLock == null) {
            return false;
        }
        return this.fileLock.isValid();
    }

    public Path getPath() {
        return this.filepath;
    }

    private void free() {
        try {
            if (this.fileLock != null) {
                this.fileLock.release();
            }
            this.fileChannel.close();
            this.fileLock = null;
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
        }
    }

    private boolean lockOperation(NoLockAction action) {
        Object object = sync;
        synchronized (object) {
            if (this.fileLock != null) {
                throw new AlreadyLocked("Failed to get a lock: file='" + String.valueOf(this.filepath) + "': Lock already held");
            }
            try {
                FileLock fileLock = this.fileLock = action != NoLockAction.WAIT ? this.fileChannel.tryLock() : this.fileChannel.lock();
                if (this.fileLock == null) {
                    switch (action.ordinal()) {
                        case 0: {
                            int pid = this.readProcessId(-99);
                            if (pid >= 0) {
                                throw new DBOpEnvException("Failed to get a lock: file='" + String.valueOf(this.filepath) + "': held by process " + pid);
                            }
                            throw new DBOpEnvException("Failed to get a lock: file='" + String.valueOf(this.filepath) + "': failed to get the holder's process id");
                        }
                        case 1: {
                            return false;
                        }
                        case 2: {
                            throw new InternalError("FileChannel.lock returned null");
                        }
                    }
                }
                int pid = ProcessUtils.getPid(-1);
                this.writeProcessId(pid);
                return true;
            }
            catch (IOException ex) {
                if (action == NoLockAction.RETURN) {
                    return false;
                }
                throw new DBOpEnvException("Failed to get a lock: file='" + String.valueOf(this.filepath) + "'", ex);
            }
        }
    }

    private int readProcessId(int dft) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(128);
        this.fileChannel.position(0L);
        int len = this.fileChannel.read(bb);
        this.fileChannel.position(0L);
        if (len == 0) {
            return dft;
        }
        if (len == 128) {
            return dft;
        }
        bb.flip();
        byte[] b = new byte[len];
        bb.get(b);
        String pidStr = StrUtils.fromUTF8bytes((byte[])b);
        pidStr = pidStr.replaceAll("[\\s\\t\\n\\r]+$", "");
        pidStr = pidStr.replaceAll("^[\\s\\t\\n\\r]+", "");
        try {
            return Integer.parseInt(pidStr);
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            Log.warn((Object)this, (String)("Bad process id: file='" + String.valueOf(this.filepath) + "': read='" + pidStr + "'"));
            return dft;
        }
    }

    private void writeProcessId(int pid) throws IOException {
        byte[] b = StrUtils.asUTF8bytes((String)(Integer.toString(pid) + "\n"));
        this.fileChannel.truncate(0L);
        int len = this.fileChannel.write(ByteBuffer.wrap(b));
        this.fileChannel.position(0L);
    }

    private static enum NoLockAction {
        EXCEPTION,
        RETURN,
        WAIT;

    }
}

