/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.mgt;

import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SubjectFactory;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.SubjectContext;
import org.apache.shiro.subject.support.DelegatingSubject;

public class DefaultSubjectFactory
implements SubjectFactory {
    @Override
    public Subject createSubject(SubjectContext context2) {
        SecurityManager securityManager = context2.resolveSecurityManager();
        Session session = context2.resolveSession();
        boolean sessionCreationEnabled = context2.isSessionCreationEnabled();
        PrincipalCollection principals = context2.resolvePrincipals();
        boolean authenticated = context2.resolveAuthenticated();
        String host = context2.resolveHost();
        return new DelegatingSubject(principals, authenticated, host, session, sessionCreationEnabled, securityManager);
    }

    @Deprecated
    protected Subject newSubjectInstance(PrincipalCollection principals, boolean authenticated, String host, Session session, SecurityManager securityManager) {
        return new DelegatingSubject(principals, authenticated, host, session, true, securityManager);
    }
}

