/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene101;

import java.util.Objects;
import org.apache.lucene.backward_codecs.lucene101.Lucene101PostingsFormat;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.CompoundFormat;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.codecs.NormsFormat;
import org.apache.lucene.codecs.PointsFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.TermVectorsFormat;
import org.apache.lucene.codecs.lucene90.Lucene90CompoundFormat;
import org.apache.lucene.codecs.lucene90.Lucene90DocValuesFormat;
import org.apache.lucene.codecs.lucene90.Lucene90LiveDocsFormat;
import org.apache.lucene.codecs.lucene90.Lucene90NormsFormat;
import org.apache.lucene.codecs.lucene90.Lucene90PointsFormat;
import org.apache.lucene.codecs.lucene90.Lucene90StoredFieldsFormat;
import org.apache.lucene.codecs.lucene90.Lucene90TermVectorsFormat;
import org.apache.lucene.codecs.lucene94.Lucene94FieldInfosFormat;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsFormat;
import org.apache.lucene.codecs.lucene99.Lucene99SegmentInfoFormat;
import org.apache.lucene.codecs.perfield.PerFieldDocValuesFormat;
import org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.apache.lucene.codecs.perfield.PerFieldPostingsFormat;

public class Lucene101Codec
extends Codec {
    private final TermVectorsFormat vectorsFormat = new Lucene90TermVectorsFormat();
    private final FieldInfosFormat fieldInfosFormat = new Lucene94FieldInfosFormat();
    private final SegmentInfoFormat segmentInfosFormat = new Lucene99SegmentInfoFormat();
    private final LiveDocsFormat liveDocsFormat = new Lucene90LiveDocsFormat();
    private final CompoundFormat compoundFormat = new Lucene90CompoundFormat();
    private final NormsFormat normsFormat = new Lucene90NormsFormat();
    private final PostingsFormat defaultPostingsFormat;
    private final PostingsFormat postingsFormat = new PerFieldPostingsFormat(){

        @Override
        public PostingsFormat getPostingsFormatForField(String field) {
            return Lucene101Codec.this.getPostingsFormatForField(field);
        }
    };
    private final DocValuesFormat defaultDVFormat;
    private final DocValuesFormat docValuesFormat = new PerFieldDocValuesFormat(){

        @Override
        public DocValuesFormat getDocValuesFormatForField(String field) {
            return Lucene101Codec.this.getDocValuesFormatForField(field);
        }
    };
    private final KnnVectorsFormat defaultKnnVectorsFormat;
    private final KnnVectorsFormat knnVectorsFormat = new PerFieldKnnVectorsFormat(){

        @Override
        public KnnVectorsFormat getKnnVectorsFormatForField(String field) {
            return Lucene101Codec.this.getKnnVectorsFormatForField(field);
        }
    };
    private final StoredFieldsFormat storedFieldsFormat;

    public Lucene101Codec() {
        this(Mode.BEST_SPEED);
    }

    public Lucene101Codec(Mode mode) {
        super("Lucene101");
        this.storedFieldsFormat = new Lucene90StoredFieldsFormat(Objects.requireNonNull(mode).storedMode);
        this.defaultPostingsFormat = new Lucene101PostingsFormat();
        this.defaultDVFormat = new Lucene90DocValuesFormat();
        this.defaultKnnVectorsFormat = new Lucene99HnswVectorsFormat();
    }

    @Override
    public final StoredFieldsFormat storedFieldsFormat() {
        return this.storedFieldsFormat;
    }

    @Override
    public final TermVectorsFormat termVectorsFormat() {
        return this.vectorsFormat;
    }

    @Override
    public final PostingsFormat postingsFormat() {
        return this.postingsFormat;
    }

    @Override
    public final FieldInfosFormat fieldInfosFormat() {
        return this.fieldInfosFormat;
    }

    @Override
    public final SegmentInfoFormat segmentInfoFormat() {
        return this.segmentInfosFormat;
    }

    @Override
    public final LiveDocsFormat liveDocsFormat() {
        return this.liveDocsFormat;
    }

    @Override
    public final CompoundFormat compoundFormat() {
        return this.compoundFormat;
    }

    @Override
    public final PointsFormat pointsFormat() {
        return new Lucene90PointsFormat();
    }

    @Override
    public final KnnVectorsFormat knnVectorsFormat() {
        return this.knnVectorsFormat;
    }

    public PostingsFormat getPostingsFormatForField(String field) {
        return this.defaultPostingsFormat;
    }

    public DocValuesFormat getDocValuesFormatForField(String field) {
        return this.defaultDVFormat;
    }

    public KnnVectorsFormat getKnnVectorsFormatForField(String field) {
        return this.defaultKnnVectorsFormat;
    }

    @Override
    public final DocValuesFormat docValuesFormat() {
        return this.docValuesFormat;
    }

    @Override
    public final NormsFormat normsFormat() {
        return this.normsFormat;
    }

    public static enum Mode {
        BEST_SPEED(Lucene90StoredFieldsFormat.Mode.BEST_SPEED),
        BEST_COMPRESSION(Lucene90StoredFieldsFormat.Mode.BEST_COMPRESSION);

        private final Lucene90StoredFieldsFormat.Mode storedMode;

        private Mode(Lucene90StoredFieldsFormat.Mode storedMode) {
            this.storedMode = Objects.requireNonNull(storedMode);
        }
    }
}

