/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.utils;

import java.lang.reflect.Field;
import java.time.format.DateTimeFormatter;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;

public class DateUtils {
    private static final Cache<String, DateTimeFormatter> DATE_TIME_FORMATTER_CACHE = Cache.of(String.class, DateTimeFormatter.class).maxSize(100).supplier(pattern -> {
        if (StringUtils.isEmpty(pattern)) {
            return DateTimeFormatter.ISO_INSTANT;
        }
        try {
            for (Field f : DateTimeFormatter.class.getFields()) {
                if (!f.getName().equals(pattern)) continue;
                return (DateTimeFormatter)f.get(null);
            }
            return DateTimeFormatter.ofPattern(pattern);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw ThrowableUtils.toRex(e);
        }
    }).build();

    public static DateTimeFormatter getDateTimeFormatter(String pattern) {
        return DATE_TIME_FORMATTER_CACHE.get(pattern);
    }
}

