/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.swap;

import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.MatchResult;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.swap.ObjectSwap;
import org.apache.juneau.swaps.ClassSwap;
import org.apache.juneau.swaps.EnumerationSwap;
import org.apache.juneau.swaps.IteratorSwap;
import org.apache.juneau.swaps.LocaleSwap;
import org.apache.juneau.swaps.MatchResultSwap;
import org.apache.juneau.swaps.StackTraceElementSwap;
import org.apache.juneau.swaps.TemporalCalendarSwap;
import org.apache.juneau.swaps.TemporalDateSwap;
import org.apache.juneau.swaps.TemporalSwap;
import org.apache.juneau.swaps.TimeZoneSwap;
import org.apache.juneau.swaps.UrlSwap;
import org.apache.juneau.swaps.XMLGregorianCalendarSwap;
import org.apache.juneau.swaps.ZoneIdSwap;

public class DefaultSwaps {
    private static final Map<Class<?>, ObjectSwap<?, ?>> SWAPS = new ConcurrentHashMap();

    public static ObjectSwap<?, ?> find(ClassInfo ci) {
        ClassInfo ci2 = ci.getAllParents().stream().filter(x -> Utils.nn(SWAPS.get(x.inner()))).findFirst().orElse(null);
        return ci2 == null ? null : SWAPS.get(ci2.inner());
    }

    static {
        SWAPS.put(Enumeration.class, new EnumerationSwap());
        SWAPS.put(Iterator.class, new IteratorSwap());
        SWAPS.put(Locale.class, new LocaleSwap());
        SWAPS.put(Class.class, new ClassSwap());
        SWAPS.put(Calendar.class, new TemporalCalendarSwap.IsoOffsetDateTime());
        SWAPS.put(Date.class, new TemporalDateSwap.IsoLocalDateTime());
        SWAPS.put(Instant.class, new TemporalSwap.IsoInstant());
        SWAPS.put(ZonedDateTime.class, new TemporalSwap.IsoOffsetDateTime());
        SWAPS.put(LocalDate.class, new TemporalSwap.IsoLocalDate());
        SWAPS.put(LocalDateTime.class, new TemporalSwap.IsoLocalDateTime());
        SWAPS.put(LocalTime.class, new TemporalSwap.IsoLocalTime());
        SWAPS.put(OffsetDateTime.class, new TemporalSwap.IsoOffsetDateTime());
        SWAPS.put(OffsetTime.class, new TemporalSwap.IsoOffsetTime());
        SWAPS.put(StackTraceElement.class, new StackTraceElementSwap());
        SWAPS.put(Year.class, new TemporalSwap.IsoYear());
        SWAPS.put(YearMonth.class, new TemporalSwap.IsoYearMonth());
        SWAPS.put(Temporal.class, new TemporalSwap.IsoInstant());
        SWAPS.put(TimeZone.class, new TimeZoneSwap());
        SWAPS.put(XMLGregorianCalendar.class, new XMLGregorianCalendarSwap());
        SWAPS.put(ZoneId.class, new ZoneIdSwap());
        SWAPS.put(MatchResult.class, new MatchResultSwap());
        SWAPS.put(URL.class, new UrlSwap());
    }
}

