/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.maven.repository.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import shaded.org.apache.maven.repository.internal.RemoteSnapshotMetadata;
import shaded.org.eclipse.aether.RepositorySystemSession;
import shaded.org.eclipse.aether.artifact.Artifact;
import shaded.org.eclipse.aether.deployment.DeployRequest;
import shaded.org.eclipse.aether.impl.MetadataGenerator;
import shaded.org.eclipse.aether.metadata.Metadata;
import shaded.org.eclipse.aether.util.ConfigUtils;

class RemoteSnapshotMetadataGenerator
implements MetadataGenerator {
    private final Map<Object, RemoteSnapshotMetadata> snapshots;
    private final boolean legacyFormat;
    private final Date timestamp;
    private final Integer buildNumber;

    RemoteSnapshotMetadataGenerator(RepositorySystemSession session, DeployRequest request) {
        this.legacyFormat = ConfigUtils.getBoolean(session, false, "maven.metadata.legacy");
        this.timestamp = (Date)ConfigUtils.getObject(session, (Object)new Date(), "maven.startTime");
        Object bn = ConfigUtils.getObject(session, null, "maven.buildNumber");
        this.buildNumber = bn instanceof Integer ? (Integer)bn : (bn instanceof String ? Integer.valueOf((String)bn) : null);
        this.snapshots = new LinkedHashMap<Object, RemoteSnapshotMetadata>();
        for (Metadata metadata : request.getMetadata()) {
            if (!(metadata instanceof RemoteSnapshotMetadata)) continue;
            RemoteSnapshotMetadata snapshotMetadata = (RemoteSnapshotMetadata)metadata;
            this.snapshots.put(snapshotMetadata.getKey(), snapshotMetadata);
        }
    }

    @Override
    public Collection<? extends Metadata> prepare(Collection<? extends Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            if (!artifact.isSnapshot()) continue;
            Object key = RemoteSnapshotMetadata.getKey(artifact);
            RemoteSnapshotMetadata snapshotMetadata = this.snapshots.get(key);
            if (snapshotMetadata == null) {
                snapshotMetadata = new RemoteSnapshotMetadata(artifact, this.legacyFormat, this.timestamp, this.buildNumber);
                this.snapshots.put(key, snapshotMetadata);
            }
            snapshotMetadata.bind(artifact);
        }
        return this.snapshots.values();
    }

    @Override
    public Artifact transformArtifact(Artifact artifact) {
        Object key;
        RemoteSnapshotMetadata snapshotMetadata;
        if (artifact.isSnapshot() && artifact.getVersion().equals(artifact.getBaseVersion()) && (snapshotMetadata = this.snapshots.get(key = RemoteSnapshotMetadata.getKey(artifact))) != null) {
            artifact = artifact.setVersion(snapshotMetadata.getExpandedVersion(artifact));
        }
        return artifact;
    }

    @Override
    public Collection<? extends Metadata> finish(Collection<? extends Artifact> artifacts) {
        return Collections.emptyList();
    }
}

