/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.karaf.cellar.etcd;

import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Set;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

public class EtcdDiscoveryServiceTest {

    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdDiscoveryServiceTest.class);

    @Ignore
    @Test
    public void testDiscovery() {
        EtcdDiscoveryService discovery = new EtcdDiscoveryService();
        discovery.setEtcdServiceName("karaf");
        discovery.setEtcdEndpoint("http://127.0.0.1:2379");
        discovery.signIn();

        Set<String> members = discovery.discoverMembers();
        assertFalse(members.isEmpty());

        //LOGGER.info("members : {}", members);
    }

    @Ignore
    @Test
    public void testDiscoveryFailure() {
        EtcdDiscoveryService discovery = new EtcdDiscoveryService();
        discovery.setEtcdServiceName("invalidServiceName");
        discovery.setEtcdEndpoint("http://127.0.0.1:2379");
        discovery.signIn();

        Set<String> members = discovery.discoverMembers();
        assertTrue(members.isEmpty());
    }
}
