/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;

@Experimental
@Immutable
public enum DependencyScope {
    NONE("none", false),
    UNDEFINED("", false),
    COMPILE_ONLY("compile-only", false),
    COMPILE("compile", true),
    RUNTIME("runtime", true),
    PROVIDED("provided", false),
    TEST_ONLY("test-only", false),
    TEST("test", false),
    TEST_RUNTIME("test-runtime", false),
    SYSTEM("system", false);

    private static final Map<String, DependencyScope> IDS;
    private final String id;
    private final boolean transitive;

    public static DependencyScope forId(String id) {
        return IDS.get(id);
    }

    private DependencyScope(String id, boolean transitive) {
        this.id = id;
        this.transitive = transitive;
    }

    @Nonnull
    public String id() {
        return this.id;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public boolean is(String id) {
        return this.id().equals(id);
    }

    static {
        IDS = Collections.unmodifiableMap(Stream.of(DependencyScope.values()).collect(Collectors.toMap(s -> s.id, s -> s)));
    }
}

