/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIViewRoot;
import javax.faces.event.PreDestroyCustomScopeEvent;
import javax.faces.event.PreDestroyViewMapEvent;
import javax.faces.event.ScopeContext;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.annotation.LifecycleProvider;

public class ManagedBeanDestroyer
implements SystemEventListener {
    private static Logger log = Logger.getLogger(ManagedBeanDestroyer.class.getName());
    private RuntimeConfig _runtimeConfig;
    private LifecycleProvider _lifecycleProvider;

    public ManagedBeanDestroyer(LifecycleProvider lifecycleProvider, RuntimeConfig runtimeConfig) {
        this._lifecycleProvider = lifecycleProvider;
        this._runtimeConfig = runtimeConfig;
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof ScopeContext || source instanceof UIViewRoot;
    }

    public void processEvent(SystemEvent event) {
        Map scope = null;
        if (event instanceof PreDestroyViewMapEvent) {
            UIViewRoot viewRoot = (UIViewRoot)((PreDestroyViewMapEvent)event).getComponent();
            scope = viewRoot.getViewMap(false);
            if (scope == null) {
                return;
            }
        } else if (event instanceof PreDestroyCustomScopeEvent) {
            ScopeContext scopeContext = ((PreDestroyCustomScopeEvent)event).getContext();
            scope = scopeContext.getScope();
        } else {
            return;
        }
        if (!scope.isEmpty()) {
            String[] keys;
            Set keySet = scope.keySet();
            for (String key : keys = keySet.toArray(new String[keySet.size()])) {
                Object value = scope.get(key);
                this.destroy(key, value);
            }
        }
    }

    public boolean isManagedBean(String name) {
        return this._runtimeConfig.getManagedBean(name) != null;
    }

    public void destroy(String name, Object instance) {
        if (instance != null && this.isManagedBean(name)) {
            try {
                this._lifecycleProvider.destroyInstance(instance);
            }
            catch (IllegalAccessException e) {
                log.log(Level.SEVERE, "Could not access @PreDestroy method of managed bean " + name, e);
            }
            catch (InvocationTargetException e) {
                log.log(Level.SEVERE, "An Exception occured while invoking @PreDestroy method of managed bean " + name, e);
            }
        }
    }
}

