/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.layout;

import org.apache.myfaces.tobago.layout.LayoutComponent;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.Orientation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Interval {
    private static final Logger LOG = LoggerFactory.getLogger(Interval.class);
    private final Measure minimum;
    private final Measure preferred;
    private final Measure maximum;
    private final Measure current;

    public Interval(LayoutComponent component, Orientation orientation) {
        this(orientation == Orientation.HORIZONTAL ? component.getMinimumWidth() : component.getMinimumHeight(), orientation == Orientation.HORIZONTAL ? component.getPreferredWidth() : component.getPreferredHeight(), orientation == Orientation.HORIZONTAL ? component.getMaximumWidth() : component.getMaximumHeight(), orientation == Orientation.HORIZONTAL ? component.getCurrentWidth() : component.getCurrentHeight());
    }

    public Interval(Measure minimum, Measure preferred, Measure maximum, Measure current) {
        if (LOG.isWarnEnabled()) {
            if (minimum != null && minimum.greaterThan(preferred)) {
                LOG.warn("Minimum '{}' is not smaller or equals preferred '{}'.", (Object)minimum, (Object)preferred);
            }
            if (preferred != null && preferred.greaterThan(maximum)) {
                LOG.warn("Preferred '{}' is not smaller or equals maximum '{}'.", (Object)preferred, (Object)maximum);
            }
        }
        this.minimum = minimum;
        this.preferred = preferred;
        this.maximum = maximum;
        this.current = current;
    }

    public Interval(Interval interval, int divider) {
        this.minimum = interval.minimum != null ? interval.minimum.divide(divider) : null;
        this.preferred = interval.preferred != null ? interval.preferred.divide(divider) : null;
        this.maximum = interval.maximum != null ? interval.maximum.divide(divider) : null;
        this.current = interval.current != null ? interval.current.divide(divider) : null;
    }

    public Measure getMinimum() {
        return this.minimum;
    }

    public Measure getPreferred() {
        return this.preferred;
    }

    public Measure getMaximum() {
        return this.maximum;
    }

    public Measure getCurrent() {
        return this.current;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.minimum);
        builder.append("<=");
        builder.append(this.preferred);
        builder.append("<=");
        builder.append(this.maximum);
        builder.append(",");
        builder.append(this.current);
        builder.append("]");
        return builder.toString();
    }
}

