/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.postgresql;

import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.TransactionalExecutionTemplate;
import org.flywaydb.core.internal.strategy.RetryStrategy;
import org.flywaydb.core.internal.util.SqlCallable;
import org.flywaydb.database.postgresql.PostgreSQLConfigurationExtension;

public class PostgreSQLAdvisoryLockTemplate {
    @Generated
    private static final Log LOG = LogFactory.getLog(PostgreSQLAdvisoryLockTemplate.class);
    private static final long LOCK_MAGIC_NUM = 77431708279161L;
    private final Configuration configuration;
    private final JdbcTemplate jdbcTemplate;
    private final long lockNum;

    PostgreSQLAdvisoryLockTemplate(Configuration configuration, JdbcTemplate jdbcTemplate, int discriminator) {
        this.configuration = configuration;
        this.jdbcTemplate = jdbcTemplate;
        this.lockNum = 77431708279161L + (long)discriminator;
    }

    public <T> T execute(Callable<T> callable) {
        PostgreSQLConfigurationExtension configurationExtension = (PostgreSQLConfigurationExtension)this.configuration.getPluginRegister().getPlugin(PostgreSQLConfigurationExtension.class);
        if (configurationExtension.isTransactionalLock()) {
            return (T)new TransactionalExecutionTemplate(this.jdbcTemplate.getConnection(), true).execute(() -> this.execute(callable, (SqlCallable<Boolean>)((SqlCallable)this::tryLockTransactional)));
        }
        RuntimeException rethrow = null;
        try {
            T t = this.execute(callable, (SqlCallable<Boolean>)((SqlCallable)this::tryLock));
            return t;
        }
        catch (RuntimeException e) {
            rethrow = e;
            throw rethrow;
        }
        finally {
            this.unlock(rethrow);
        }
    }

    private <T> T execute(Callable<T> callable, SqlCallable<Boolean> tryLock) {
        try {
            this.lock(tryLock);
            return callable.call();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to acquire PostgreSQL advisory lock", e);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new FlywayException((Throwable)e);
        }
    }

    private void lock(SqlCallable<Boolean> tryLock) throws SQLException {
        RetryStrategy strategy = new RetryStrategy();
        strategy.doWithRetries(tryLock, "Interrupted while attempting to acquire PostgreSQL advisory lock", "Number of retries exceeded while attempting to acquire PostgreSQL advisory lock. Configure the number of retries with the 'lockRetryCount' configuration option: https://rd.gt/3A57jfk");
    }

    private boolean tryLockTransactional() throws SQLException {
        List results = this.jdbcTemplate.query("SELECT pg_try_advisory_xact_lock(" + this.lockNum + ")", rs -> rs.getBoolean("pg_try_advisory_xact_lock"), new Object[0]);
        return results.size() == 1 && (Boolean)results.get(0) != false;
    }

    private boolean tryLock() throws SQLException {
        List results = this.jdbcTemplate.query("SELECT pg_try_advisory_lock(" + this.lockNum + ")", rs -> rs.getBoolean("pg_try_advisory_lock"), new Object[0]);
        return results.size() == 1 && (Boolean)results.get(0) != false;
    }

    private void unlock(RuntimeException rethrow) throws FlywaySqlException {
        try {
            boolean unlocked = this.jdbcTemplate.queryForBoolean("SELECT pg_advisory_unlock(" + this.lockNum + ")", new String[0]);
            if (!unlocked) {
                if (rethrow == null) {
                    throw new FlywayException("Unable to release PostgreSQL advisory lock");
                }
                LOG.error("Unable to release PostgreSQL advisory lock");
            }
        }
        catch (SQLException e) {
            if (rethrow == null) {
                throw new FlywaySqlException("Unable to release PostgreSQL advisory lock", e);
            }
            LOG.error("Unable to release PostgreSQL advisory lock", (Exception)e);
        }
    }
}

