/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.nar;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchService;
import java.util.Objects;
import org.apache.nifi.minifi.nar.NarAutoUnloadService;
import org.apache.nifi.minifi.nar.NarAutoUnloaderTask;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarLoader;
import org.apache.nifi.util.FileUtils;
import org.apache.nifi.util.NiFiProperties;

public class NarAutoUnloaderTaskFactory {
    private final NiFiProperties properties;
    private final ExtensionManager extensionManager;
    private final NarLoader narLoader;

    public NarAutoUnloaderTaskFactory(NiFiProperties properties, ExtensionManager extensionManager, NarLoader narLoader) {
        this.properties = Objects.requireNonNull(properties);
        this.extensionManager = Objects.requireNonNull(extensionManager);
        this.narLoader = Objects.requireNonNull(narLoader);
    }

    public NarAutoUnloaderTask createNarAutoUnloaderTask() throws IOException {
        File autoLoadDir = this.properties.getNarAutoLoadDirectory();
        FileUtils.ensureDirectoryExistAndCanRead((File)autoLoadDir);
        WatchService watcher = FileSystems.getDefault().newWatchService();
        Path autoLoadPath = autoLoadDir.toPath();
        autoLoadPath.register(watcher, StandardWatchEventKinds.ENTRY_DELETE);
        NarAutoUnloadService narAutoUnloadService = new NarAutoUnloadService(this.extensionManager, this.properties.getExtensionsWorkingDirectory(), this.narLoader);
        return new NarAutoUnloaderTask(autoLoadPath, watcher, narAutoUnloadService);
    }
}

