/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;

public class SortedResourcesFactoryBean
extends AbstractFactoryBean<Resource[]>
implements ResourceLoaderAware {
    private final List<String> locations;
    private ResourcePatternResolver resourcePatternResolver;

    public SortedResourcesFactoryBean(List<String> locations) {
        this.locations = locations;
        this.resourcePatternResolver = new PathMatchingResourcePatternResolver();
    }

    public SortedResourcesFactoryBean(ResourceLoader resourceLoader, List<String> locations) {
        this.locations = locations;
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
    }

    public Class<? extends Resource[]> getObjectType() {
        return Resource[].class;
    }

    protected Resource[] createInstance() throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        for (String location : this.locations) {
            Resource[] resources = this.resourcePatternResolver.getResources(location);
            LinkedHashMap<Resource, String> urlCache = new LinkedHashMap<Resource, String>(resources.length);
            ArrayList<Resource> failingResources = new ArrayList<Resource>();
            for (Resource resource : resources) {
                try {
                    urlCache.put(resource, resource.getURL().toString());
                }
                catch (IOException ex) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Failed to resolve " + String.valueOf(resource) + " for sorting purposes: " + String.valueOf(ex)));
                    }
                    failingResources.add(resource);
                }
            }
            ArrayList sortedResources = new ArrayList(urlCache.keySet());
            sortedResources.sort(Comparator.comparing(urlCache::get));
            result.addAll(sortedResources);
            result.addAll(failingResources);
        }
        return result.toArray(new Resource[0]);
    }
}

