/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.kafka;

import java.util.List;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetails;
import org.springframework.boot.ssl.SslBundle;

public interface KafkaConnectionDetails
extends ConnectionDetails {
    public List<String> getBootstrapServers();

    default public SslBundle getSslBundle() {
        return null;
    }

    default public String getSecurityProtocol() {
        return null;
    }

    default public Configuration getConsumer() {
        return Configuration.of(this.getBootstrapServers(), this.getSslBundle(), this.getSecurityProtocol());
    }

    default public Configuration getProducer() {
        return Configuration.of(this.getBootstrapServers(), this.getSslBundle(), this.getSecurityProtocol());
    }

    default public Configuration getAdmin() {
        return Configuration.of(this.getBootstrapServers(), this.getSslBundle(), this.getSecurityProtocol());
    }

    default public Configuration getStreams() {
        return Configuration.of(this.getBootstrapServers(), this.getSslBundle(), this.getSecurityProtocol());
    }

    @Deprecated(since="3.5.0", forRemoval=true)
    default public List<String> getConsumerBootstrapServers() {
        return this.getConsumer().getBootstrapServers();
    }

    @Deprecated(since="3.5.0", forRemoval=true)
    default public List<String> getProducerBootstrapServers() {
        return this.getProducer().getBootstrapServers();
    }

    @Deprecated(since="3.5.0", forRemoval=true)
    default public List<String> getAdminBootstrapServers() {
        return this.getAdmin().getBootstrapServers();
    }

    @Deprecated(since="3.5.0", forRemoval=true)
    default public List<String> getStreamsBootstrapServers() {
        return this.getStreams().getBootstrapServers();
    }

    public static interface Configuration {
        public static Configuration of(List<String> bootstrapServers) {
            return Configuration.of(bootstrapServers, null, null);
        }

        public static Configuration of(List<String> bootstrapServers, SslBundle sslBundle) {
            return Configuration.of(bootstrapServers, sslBundle, null);
        }

        public static Configuration of(final List<String> bootstrapServers, final SslBundle sslBundle, final String securityProtocol) {
            return new Configuration(){

                @Override
                public List<String> getBootstrapServers() {
                    return bootstrapServers;
                }

                @Override
                public SslBundle getSslBundle() {
                    return sslBundle;
                }

                @Override
                public String getSecurityProtocol() {
                    return securityProtocol;
                }
            };
        }

        public List<String> getBootstrapServers();

        default public SslBundle getSslBundle() {
            return null;
        }

        default public String getSecurityProtocol() {
            return null;
        }
    }
}

