/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import org.jspecify.annotations.Nullable;
import org.springframework.security.access.hierarchicalroles.NullRoleHierarchy;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.authorization.AllAuthoritiesAuthorizationManager;
import org.springframework.security.authorization.AuthenticatedAuthorizationManager;
import org.springframework.security.authorization.AuthorityAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationManagerFactory;
import org.springframework.security.authorization.AuthorizationManagers;
import org.springframework.util.Assert;

public final class DefaultAuthorizationManagerFactory<T>
implements AuthorizationManagerFactory<T> {
    private AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();
    private RoleHierarchy roleHierarchy = new NullRoleHierarchy();
    private String rolePrefix = "ROLE_";
    private @Nullable AuthorizationManager<T> additionalAuthorization;

    public void setTrustResolver(AuthenticationTrustResolver trustResolver) {
        Assert.notNull((Object)trustResolver, (String)"trustResolver cannot be null");
        this.trustResolver = trustResolver;
    }

    public void setRoleHierarchy(RoleHierarchy roleHierarchy) {
        Assert.notNull((Object)roleHierarchy, (String)"roleHierarchy cannot be null");
        this.roleHierarchy = roleHierarchy;
    }

    public void setRolePrefix(String rolePrefix) {
        Assert.notNull((Object)rolePrefix, (String)"rolePrefix cannot be null");
        this.rolePrefix = rolePrefix;
    }

    public void setAdditionalAuthorization(@Nullable AuthorizationManager<T> additionalAuthorization) {
        this.additionalAuthorization = additionalAuthorization;
    }

    @Override
    public AuthorizationManager<T> hasRole(String role) {
        return this.hasAnyRole(role);
    }

    @Override
    public AuthorizationManager<T> hasAnyRole(String ... roles) {
        return this.createManager(AuthorityAuthorizationManager.hasAnyRole(this.rolePrefix, roles));
    }

    @Override
    public AuthorizationManager<T> hasAllRoles(String ... roles) {
        return this.createManager(AllAuthoritiesAuthorizationManager.hasAllPrefixedAuthorities(this.rolePrefix, roles));
    }

    @Override
    public AuthorizationManager<T> hasAuthority(String authority) {
        return this.createManager(AuthorityAuthorizationManager.hasAuthority(authority));
    }

    @Override
    public AuthorizationManager<T> hasAnyAuthority(String ... authorities) {
        return this.createManager(AuthorityAuthorizationManager.hasAnyAuthority(authorities));
    }

    @Override
    public AuthorizationManager<T> hasAllAuthorities(String ... authorities) {
        return this.createManager(AllAuthoritiesAuthorizationManager.hasAllAuthorities(authorities));
    }

    @Override
    public AuthorizationManager<T> authenticated() {
        return this.createManager(AuthenticatedAuthorizationManager.authenticated());
    }

    @Override
    public AuthorizationManager<T> fullyAuthenticated() {
        return this.createManager(AuthenticatedAuthorizationManager.fullyAuthenticated());
    }

    @Override
    public AuthorizationManager<T> rememberMe() {
        return this.createManager(AuthenticatedAuthorizationManager.rememberMe());
    }

    @Override
    public AuthorizationManager<T> anonymous() {
        return this.createManager(AuthenticatedAuthorizationManager.anonymous());
    }

    private AuthorizationManager<T> createManager(AuthorityAuthorizationManager<T> authorizationManager) {
        authorizationManager.setRoleHierarchy(this.roleHierarchy);
        return this.withAdditionalAuthorization(authorizationManager);
    }

    private AuthorizationManager<T> createManager(AllAuthoritiesAuthorizationManager<T> authorizationManager) {
        authorizationManager.setRoleHierarchy(this.roleHierarchy);
        return this.withAdditionalAuthorization(authorizationManager);
    }

    private AuthorizationManager<T> createManager(AuthenticatedAuthorizationManager<T> authorizationManager) {
        authorizationManager.setTrustResolver(this.trustResolver);
        return this.withAdditionalAuthorization(authorizationManager);
    }

    private AuthorizationManager<T> withAdditionalAuthorization(AuthorizationManager<T> manager) {
        if (this.additionalAuthorization == null) {
            return manager;
        }
        return AuthorizationManagers.allOf(new AuthorizationDecision(false), this.additionalAuthorization, manager);
    }
}

