/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry;

import org.apache.nifi.flow.VersionedExternalFlow;
import org.apache.nifi.flow.VersionedExternalFlowMetadata;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;

public class VersionedFlowConverter {
    public static VersionedExternalFlow createVersionedExternalFlow(VersionedFlowSnapshot flowSnapshot) {
        VersionedFlow versionedFlow;
        VersionedExternalFlowMetadata externalFlowMetadata = new VersionedExternalFlowMetadata();
        VersionedFlowSnapshotMetadata snapshotMetadata = flowSnapshot.getSnapshotMetadata();
        if (snapshotMetadata != null) {
            externalFlowMetadata.setAuthor(snapshotMetadata.getAuthor());
            externalFlowMetadata.setBucketIdentifier(snapshotMetadata.getBucketIdentifier());
            externalFlowMetadata.setComments(snapshotMetadata.getComments());
            externalFlowMetadata.setFlowIdentifier(snapshotMetadata.getFlowIdentifier());
            externalFlowMetadata.setTimestamp(snapshotMetadata.getTimestamp());
            externalFlowMetadata.setVersion(String.valueOf(snapshotMetadata.getVersion()));
        }
        if ((versionedFlow = flowSnapshot.getFlow()) == null) {
            externalFlowMetadata.setFlowName(flowSnapshot.getFlowContents().getName());
        } else {
            externalFlowMetadata.setFlowName(versionedFlow.getName());
        }
        VersionedExternalFlow externalFlow = new VersionedExternalFlow();
        externalFlow.setFlowContents(flowSnapshot.getFlowContents());
        externalFlow.setExternalControllerServices(flowSnapshot.getExternalControllerServices());
        externalFlow.setParameterContexts(flowSnapshot.getParameterContexts());
        externalFlow.setParameterProviders(flowSnapshot.getParameterProviders());
        externalFlow.setMetadata(externalFlowMetadata);
        return externalFlow;
    }
}

