/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import kafka.log.SplitSegmentResult;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegments;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class LocalLog$
implements Logging {
    public static LocalLog$ MODULE$;
    private final String DeletedFileSuffix;
    private final String CleanedFileSuffix;
    private final String SwapFileSuffix;
    private final String DeleteDirSuffix;
    private final String FutureDirSuffix;
    private final String StrayDirSuffix;
    private final Pattern DeleteDirPattern;
    private final Pattern FutureDirPattern;
    private final Pattern StrayDirPattern;
    private final long UnknownOffset;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new LocalLog$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String DeletedFileSuffix() {
        return this.DeletedFileSuffix;
    }

    public String CleanedFileSuffix() {
        return this.CleanedFileSuffix;
    }

    public String SwapFileSuffix() {
        return this.SwapFileSuffix;
    }

    public String DeleteDirSuffix() {
        return this.DeleteDirSuffix;
    }

    public String FutureDirSuffix() {
        return this.FutureDirSuffix;
    }

    public String StrayDirSuffix() {
        return this.StrayDirSuffix;
    }

    public Pattern DeleteDirPattern() {
        return this.DeleteDirPattern;
    }

    public Pattern FutureDirPattern() {
        return this.FutureDirPattern;
    }

    public Pattern StrayDirPattern() {
        return this.StrayDirPattern;
    }

    public long UnknownOffset() {
        return this.UnknownOffset;
    }

    public String logDeleteDirName(TopicPartition topicPartition) {
        return this.logDirNameWithSuffixCappedLength(topicPartition, this.DeleteDirSuffix());
    }

    public String logStrayDirName(TopicPartition topicPartition) {
        return this.logDirNameWithSuffixCappedLength(topicPartition, this.StrayDirSuffix());
    }

    public String logFutureDirName(TopicPartition topicPartition) {
        return this.logDirNameWithSuffix(topicPartition, this.FutureDirSuffix());
    }

    public String logDirNameWithSuffixCappedLength(TopicPartition topicPartition, String suffix) {
        String uniqueId = UUID.randomUUID().toString().replaceAll("-", "");
        String fullSuffix = new StringBuilder(2).append("-").append(topicPartition.partition()).append(".").append(uniqueId).append(suffix).toString();
        int prefixLength = Math.min(new StringOps(Predef$.MODULE$.augmentString(topicPartition.topic())).size(), 255 - new StringOps(Predef$.MODULE$.augmentString(fullSuffix)).size());
        return new StringBuilder(0).append(topicPartition.topic().substring(0, prefixLength)).append(fullSuffix).toString();
    }

    public String logDirNameWithSuffix(TopicPartition topicPartition, String suffix) {
        String uniqueId = UUID.randomUUID().toString().replaceAll("-", "");
        return new StringBuilder(1).append(this.logDirName(topicPartition)).append(".").append(uniqueId).append(suffix).toString();
    }

    public String logDirName(TopicPartition topicPartition) {
        return new StringBuilder(1).append(topicPartition.topic()).append("-").append(topicPartition.partition()).toString();
    }

    public TopicPartition parseTopicPartitionName(File dir) {
        int n;
        if (dir == null) {
            throw new KafkaException("dir should not be null");
        }
        String dirName = dir.getName();
        if (dirName == null || dirName.isEmpty() || !new StringOps(Predef$.MODULE$.augmentString(dirName)).contains((Object)BoxesRunTime.boxToCharacter((char)'-'))) {
            throw LocalLog$.exception$1(dir);
        }
        if (dirName.endsWith(this.DeleteDirSuffix()) && !this.DeleteDirPattern().matcher(dirName).matches() || dirName.endsWith(this.FutureDirSuffix()) && !this.FutureDirPattern().matcher(dirName).matches() || dirName.endsWith(this.StrayDirSuffix()) && !this.StrayDirPattern().matcher(dirName).matches()) {
            throw LocalLog$.exception$1(dir);
        }
        String name = dirName.endsWith(this.DeleteDirSuffix()) || dirName.endsWith(this.FutureDirSuffix()) || dirName.endsWith(this.StrayDirSuffix()) ? dirName.substring(0, dirName.lastIndexOf(46)) : dirName;
        int index = name.lastIndexOf(45);
        String topic = name.substring(0, index);
        String partitionString = name.substring(index + 1);
        if (topic.isEmpty() || partitionString.isEmpty()) {
            throw LocalLog$.exception$1(dir);
        }
        try {
            n = new StringOps(Predef$.MODULE$.augmentString(partitionString)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw LocalLog$.exception$1(dir);
        }
        int partition = n;
        return new TopicPartition(topic, partition);
    }

    public boolean isIndexFile(File file) {
        String fileName = file.getName();
        return fileName.endsWith(".index") || fileName.endsWith(".timeindex") || fileName.endsWith(".txnindex");
    }

    public boolean isLogFile(File file) {
        return file.getPath().endsWith(".log");
    }

    public <T> T maybeHandleIOException(LogDirFailureChannel logDirFailureChannel, String logDir, Function0<String> errorMsg, Function0<T> fun) {
        if (logDirFailureChannel.hasOfflineLogDir(logDir)) {
            throw new KafkaStorageException(new StringBuilder(63).append("The log dir ").append(logDir).append(" is already offline due to a previous IO exception.").toString());
        }
        try {
            return (T)fun.apply();
        }
        catch (IOException e) {
            logDirFailureChannel.maybeAddOfflineLogDir(logDir, (String)errorMsg.apply(), e);
            throw new KafkaStorageException((String)errorMsg.apply(), (Throwable)e);
        }
    }

    public SplitSegmentResult splitOverflowedSegment(LogSegment segment, LogSegments existingSegments, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, String logPrefix) {
        Predef$.MODULE$.require(this.isLogFile(segment.log().file()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Cannot split file ").append(segment.log().file().getAbsoluteFile()).toString());
        Predef$.MODULE$.require(segment.hasOverflow(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("Split operation is only permitted for segments with overflow, and the problem path is ").append(segment.log().file().getAbsoluteFile()).toString());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(this.msgWithLogIdent(LocalLog$.$anonfun$splitOverflowedSegment$3(logPrefix, segment)));
        }
        ListBuffer newSegments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            int bytesAppended;
            FileRecords sourceRecords = segment.log();
            for (int position = 0; position < sourceRecords.sizeInBytes(); position += bytesAppended) {
                FileLogInputStream.FileChannelRecordBatch firstBatch = (FileLogInputStream.FileChannelRecordBatch)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(sourceRecords.batchesFrom(position)).asScala()).head();
                LogSegment newSegment = this.createNewCleanedSegment(dir, config, firstBatch.baseOffset());
                newSegments.$plus$eq((Object)newSegment);
                bytesAppended = newSegment.appendFromFile(sourceRecords, position);
                if (bytesAppended != 0) continue;
                throw new IllegalStateException(new StringBuilder(43).append("Failed to append records from position ").append(position).append(" in ").append(segment).toString());
            }
            IntRef totalSizeOfNewSegments = IntRef.create((int)0);
            newSegments.foreach((Function1 & Serializable & scala.Serializable)splitSegment -> {
                LocalLog$.$anonfun$splitOverflowedSegment$4(segment, totalSizeOfNewSegments, splitSegment);
                return BoxedUnit.UNIT;
            });
            if (totalSizeOfNewSegments.elem != segment.log().sizeInBytes()) {
                throw new IllegalStateException(new StringBuilder(55).append("Inconsistent segment sizes after split").append(" before: ").append(segment.log().sizeInBytes()).append(" after: ").append(totalSizeOfNewSegments.elem).toString());
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(this.msgWithLogIdent(LocalLog$.$anonfun$splitOverflowedSegment$5(logPrefix, segment, newSegments)));
            }
            Seq newSegmentsToAdd = newSegments.toSeq();
            Iterable<LogSegment> deletedSegments = this.replaceSegments(existingSegments, (Seq<LogSegment>)newSegmentsToAdd, (Seq<LogSegment>)new .colon.colon((Object)segment, (List)Nil$.MODULE$), dir, topicPartition, config, scheduler, logDirFailureChannel, logPrefix, this.replaceSegments$default$10());
            return new SplitSegmentResult((Iterable<LogSegment>)deletedSegments.toSeq(), (Iterable<LogSegment>)newSegmentsToAdd);
        }
        catch (Exception e) {
            newSegments.foreach((Function1 & Serializable & scala.Serializable)splitSegment -> {
                LocalLog$.$anonfun$splitOverflowedSegment$6(splitSegment);
                return BoxedUnit.UNIT;
            });
            throw e;
        }
    }

    public Iterable<LogSegment> replaceSegments(LogSegments existingSegments, Seq<LogSegment> newSegments, Seq<LogSegment> oldSegments, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, String logPrefix, boolean isRecoveredSwapFile) {
        Seq sortedNewSegments = (Seq)newSegments.sortBy((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.baseOffset()), (Ordering)Ordering.Long$.MODULE$);
        Seq sortedOldSegments = (Seq)((SeqLike)oldSegments.filter((Function1 & Serializable & scala.Serializable)seg -> BoxesRunTime.boxToBoolean((boolean)existingSegments.contains(seg.baseOffset())))).sortBy((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.baseOffset()), (Ordering)Ordering.Long$.MODULE$);
        if (!isRecoveredSwapFile) {
            ((IterableLike)sortedNewSegments.reverse()).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                x$7.changeFileSuffixes(LocalLog$.MODULE$.CleanedFileSuffix(), LocalLog$.MODULE$.SwapFileSuffix());
                return BoxedUnit.UNIT;
            });
        }
        ((IterableLike)sortedNewSegments.reverse()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> existingSegments.add(x$1));
        Set newSegmentBaseOffsets = ((TraversableOnce)sortedNewSegments.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.baseOffset()), Seq$.MODULE$.canBuildFrom())).toSet();
        Seq deletedNotReplaced = (Seq)((TraversableLike)((TraversableLike)sortedOldSegments.map((Function1 & Serializable & scala.Serializable)seg -> {
            if (seg.baseOffset() != ((LogSegment)sortedNewSegments.head()).baseOffset()) {
                existingSegments.remove(seg.baseOffset());
            }
            MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable<LogSegment>)new .colon.colon(seg, (List)Nil$.MODULE$), true, dir, topicPartition, config, scheduler, logDirFailureChannel, logPrefix);
            if (newSegmentBaseOffsets.contains((Object)BoxesRunTime.boxToLong((long)seg.baseOffset()))) {
                return Option$.MODULE$.empty();
            }
            return new Some(seg);
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)item -> BoxesRunTime.boxToBoolean((boolean)item.isDefined()))).map((Function1 & Serializable & scala.Serializable)item -> (LogSegment)item.get(), Seq$.MODULE$.canBuildFrom());
        sortedNewSegments.foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            x$9.changeFileSuffixes(LocalLog$.MODULE$.SwapFileSuffix(), "");
            return BoxedUnit.UNIT;
        });
        Utils.flushDir((Path)dir.toPath());
        return deletedNotReplaced;
    }

    public boolean replaceSegments$default$10() {
        return false;
    }

    public void deleteSegmentFiles(scala.collection.immutable.Iterable<LogSegment> segmentsToDelete, boolean asyncDelete, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, String logPrefix) {
        segmentsToDelete.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LocalLog$.$anonfun$deleteSegmentFiles$1(segment);
            return BoxedUnit.UNIT;
        });
        if (asyncDelete) {
            scheduler.scheduleOnce("delete-file", () -> this.deleteSegments$1(logPrefix, segmentsToDelete, dir, logDirFailureChannel, topicPartition), config.fileDeleteDelayMs);
            return;
        }
        this.deleteSegments$1(logPrefix, segmentsToDelete, dir, logDirFailureChannel, topicPartition);
    }

    public FetchDataInfo emptyFetchDataInfo(LogOffsetMetadata fetchOffsetMetadata, boolean includeAbortedTxns) {
        Optional<Object> abortedTransactions = includeAbortedTxns ? Optional.of(Collections.emptyList()) : Optional.empty();
        return new FetchDataInfo(fetchOffsetMetadata, (Records)MemoryRecords.EMPTY, false, abortedTransactions);
    }

    public LogSegment createNewCleanedSegment(File dir, LogConfig logConfig, long baseOffset) {
        LogSegment.deleteIfExists((File)dir, (long)baseOffset, (String)this.CleanedFileSuffix());
        return LogSegment.open((File)dir, (long)baseOffset, (LogConfig)logConfig, (Time)Time.SYSTEM, (boolean)false, (int)logConfig.initFileSize(), (boolean)logConfig.preallocate, (String)this.CleanedFileSuffix());
    }

    public <T> Option<T> nextOption(Iterator<T> iterator) {
        if (iterator.hasNext()) {
            return new Some(iterator.next());
        }
        return None$.MODULE$;
    }

    private static final KafkaException exception$1(File dir) {
        return new KafkaException(new StringBuilder(196).append("Found directory ").append(dir.getCanonicalPath()).append(", '").append(dir.getName()).append("' is not in the form of ").append("topic-partition or topic-partition.uniqueId-delete (if marked for deletion).\n").append("Kafka's log directories (and children) should only contain Kafka topic data.").toString());
    }

    public static final /* synthetic */ String $anonfun$splitOverflowedSegment$3(String logPrefix$1, LogSegment segment$1) {
        return new StringBuilder(29).append(logPrefix$1).append("Splitting overflowed segment ").append(segment$1).toString();
    }

    public static final /* synthetic */ void $anonfun$splitOverflowedSegment$4(LogSegment segment$1, IntRef totalSizeOfNewSegments$1, LogSegment splitSegment) {
        splitSegment.onBecomeInactiveSegment();
        splitSegment.flush();
        splitSegment.setLastModified(segment$1.lastModified());
        totalSizeOfNewSegments$1.elem += splitSegment.log().sizeInBytes();
    }

    public static final /* synthetic */ String $anonfun$splitOverflowedSegment$5(String logPrefix$1, LogSegment segment$1, ListBuffer newSegments$1) {
        return new StringBuilder(50).append(logPrefix$1).append("Replacing overflowed segment ").append(segment$1).append(" with split segments ").append(newSegments$1).toString();
    }

    public static final /* synthetic */ void $anonfun$splitOverflowedSegment$6(LogSegment splitSegment) {
        splitSegment.close();
        splitSegment.deleteIfExists();
    }

    public static final /* synthetic */ void $anonfun$deleteSegmentFiles$1(LogSegment segment) {
        if (!segment.hasSuffix(".deleted")) {
            segment.changeFileSuffixes("", ".deleted");
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$deleteSegmentFiles$2(String logPrefix$3, scala.collection.immutable.Iterable segmentsToDelete$1) {
        return new StringBuilder(23).append(logPrefix$3).append("Deleting segment files ").append(segmentsToDelete$1.mkString(",")).toString();
    }

    public static final /* synthetic */ String $anonfun$deleteSegmentFiles$3(TopicPartition topicPartition$2, String parentDir$1) {
        return new StringBuilder(42).append("Error while deleting segments for ").append(topicPartition$2).append(" in dir ").append(parentDir$1).toString();
    }

    private final void deleteSegments$1(String logPrefix$3, scala.collection.immutable.Iterable segmentsToDelete$1, File dir$2, LogDirFailureChannel logDirFailureChannel$2, TopicPartition topicPartition$2) {
        String parentDir;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(this.msgWithLogIdent(LocalLog$.$anonfun$deleteSegmentFiles$2(logPrefix$3, segmentsToDelete$1)));
        }
        if (logDirFailureChannel$2.hasOfflineLogDir(parentDir = dir$2.getParent())) {
            throw new KafkaStorageException(new StringBuilder(63).append("The log dir ").append(parentDir).append(" is already offline due to a previous IO exception.").toString());
        }
        try {
            segmentsToDelete$1.foreach((Function1 & Serializable & scala.Serializable)segment -> {
                segment.deleteIfExists();
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (IOException maybeHandleIOException_e) {
            logDirFailureChannel$2.maybeAddOfflineLogDir(parentDir, LocalLog$.$anonfun$deleteSegmentFiles$3(topicPartition$2, parentDir), maybeHandleIOException_e);
            throw new KafkaStorageException(LocalLog$.$anonfun$deleteSegmentFiles$3(topicPartition$2, parentDir), (Throwable)maybeHandleIOException_e);
        }
    }

    private LocalLog$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.DeletedFileSuffix = ".deleted";
        this.CleanedFileSuffix = ".cleaned";
        this.SwapFileSuffix = ".swap";
        this.DeleteDirSuffix = "-delete";
        this.FutureDirSuffix = "-future";
        this.StrayDirSuffix = "-stray";
        this.DeleteDirPattern = Pattern.compile(new StringBuilder(19).append("^(\\S+)-(\\S+)\\.(\\S+)").append(this.DeleteDirSuffix()).toString());
        this.FutureDirPattern = Pattern.compile(new StringBuilder(19).append("^(\\S+)-(\\S+)\\.(\\S+)").append(this.FutureDirSuffix()).toString());
        this.StrayDirPattern = Pattern.compile(new StringBuilder(19).append("^(\\S+)-(\\S+)\\.(\\S+)").append(this.StrayDirSuffix()).toString());
        this.UnknownOffset = -1L;
    }
}

