/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol.okhttp;

import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.protocol.okhttp.CIDR;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPFilterRules {
    protected static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    List<Predicate<InetAddress>> includeRules;
    List<Predicate<InetAddress>> excludeRules;

    public IPFilterRules(Configuration conf) {
        this.includeRules = IPFilterRules.parseIPRules(conf, "http.filter.ipaddress.include");
        this.excludeRules = IPFilterRules.parseIPRules(conf, "http.filter.ipaddress.exclude");
    }

    public boolean isEmpty() {
        return this.includeRules.size() <= 0 && this.excludeRules.size() <= 0;
    }

    public boolean accept(InetAddress address) {
        boolean accept = true;
        if (this.includeRules.size() > 0) {
            accept = false;
            for (Predicate<InetAddress> rule : this.includeRules) {
                if (!rule.test(address)) continue;
                accept = true;
                break;
            }
        }
        if (accept && this.excludeRules.size() > 0) {
            for (Predicate<InetAddress> rule : this.excludeRules) {
                if (!rule.test(address)) continue;
                accept = false;
                break;
            }
        }
        return accept;
    }

    private static List<Predicate<InetAddress>> parseIPRules(Configuration conf, String ipRuleProperty) {
        ArrayList<Predicate<InetAddress>> rules = new ArrayList<Predicate<InetAddress>>();
        String[] ipRules = conf.getStrings(ipRuleProperty);
        if (ipRules == null) {
            return rules;
        }
        block11: for (String ipRule : ipRules) {
            switch (ipRule.toLowerCase()) {
                case "localhost": 
                case "loopback": {
                    rules.add(a -> a.isLoopbackAddress());
                    continue block11;
                }
                case "sitelocal": {
                    rules.add(a -> a.isSiteLocalAddress());
                    continue block11;
                }
                default: {
                    try {
                        CIDR cidr = new CIDR(ipRule);
                        rules.add(a -> cidr.contains((InetAddress)a));
                        continue block11;
                    }
                    catch (IllegalArgumentException e) {
                        LOG.error("Failed to parse {} as CIDR, ignoring to configure IP rules ({})", (Object)ipRule, (Object)ipRuleProperty);
                    }
                }
            }
        }
        if (rules.size() > 0) {
            LOG.info("Found {} IP filter rules for {}", (Object)rules.size(), (Object)ipRuleProperty);
        }
        return rules;
    }
}

