/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class LogReplayTracker {
    private final Logger log;
    private boolean empty;

    private LogReplayTracker(LogContext logContext) {
        this.log = logContext.logger(LogReplayTracker.class);
        this.resetToEmpty();
    }

    void resetToEmpty() {
        this.empty = true;
    }

    boolean empty() {
        return this.empty;
    }

    void replay(ApiMessage message) {
        this.empty = false;
    }

    public static class Builder {
        private LogContext logContext = null;

        Builder setLogContext(LogContext logContext) {
            this.logContext = logContext;
            return this;
        }

        public LogReplayTracker build() {
            if (this.logContext == null) {
                this.logContext = new LogContext();
            }
            return new LogReplayTracker(this.logContext);
        }
    }
}

