/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.connector;

import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectorContext;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.errors.ConnectException;

public abstract class Connector
implements Versioned {
    protected ConnectorContext context;

    public void initialize(ConnectorContext ctx) {
        this.context = ctx;
    }

    public void initialize(ConnectorContext ctx, List<Map<String, String>> taskConfigs) {
        this.context = ctx;
    }

    protected ConnectorContext context() {
        return this.context;
    }

    public abstract void start(Map<String, String> var1);

    public void reconfigure(Map<String, String> props) {
        this.stop();
        this.start(props);
    }

    public abstract Class<? extends Task> taskClass();

    public abstract List<Map<String, String>> taskConfigs(int var1);

    public abstract void stop();

    public Config validate(Map<String, String> connectorConfigs) {
        ConfigDef configDef = this.config();
        if (null == configDef) {
            throw new ConnectException(String.format("%s.config() must return a ConfigDef that is not null.", this.getClass().getName()));
        }
        List configValues = configDef.validate(connectorConfigs);
        return new Config(configValues);
    }

    public abstract ConfigDef config();
}

