/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import opennlp.tools.ml.AlgorithmType;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.AbstractModelReader;
import opennlp.tools.ml.model.DataReader;

public class GenericModelReader
extends AbstractModelReader {
    private AbstractModelReader delegateModelReader;

    public GenericModelReader(File f) throws IOException {
        super(f);
    }

    public GenericModelReader(DataReader dataReader) {
        super(dataReader);
    }

    @Override
    public void checkModelType() throws IOException {
        this.delegateModelReader = this.fromType(AlgorithmType.fromModelType((String)this.readUTF()));
    }

    private AbstractModelReader fromType(AlgorithmType type) {
        try {
            Class<?> readerClass = Class.forName(type.getReaderClazz());
            return (AbstractModelReader)readerClass.getDeclaredConstructor(DataReader.class).newInstance(this.dataReader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Given reader is not available in the classpath!", e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Problem instantiating chosen reader class: " + type.getReaderClazz(), e);
        }
    }

    @Override
    public AbstractModel constructModel() throws IOException {
        return this.delegateModelReader.constructModel();
    }
}

