/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.admintool;

import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.polaris.admintool.BaseCommand;
import org.apache.polaris.core.persistence.bootstrap.BootstrapOptions;
import org.apache.polaris.core.persistence.bootstrap.ImmutableBootstrapOptions;
import org.apache.polaris.core.persistence.bootstrap.ImmutableSchemaOptions;
import org.apache.polaris.core.persistence.bootstrap.RootCredentialsSet;
import org.apache.polaris.core.persistence.bootstrap.SchemaOptions;
import org.apache.polaris.core.persistence.dao.entity.PrincipalSecretsResult;
import picocli.CommandLine;

@CommandLine.Command(name="bootstrap", mixinStandardHelpOptions=true, description={"Bootstraps realms and root principal credentials."})
public class BootstrapCommand
extends BaseCommand {
    @CommandLine.Mixin
    InputOptions inputOptions;

    @Override
    public Integer call() {
        try {
            ImmutableSchemaOptions schemaOptions;
            Collection<String> realms;
            RootCredentialsSet rootCredentialsSet;
            if (this.inputOptions.rootCredentialsOptions.fileOptions != null) {
                rootCredentialsSet = RootCredentialsSet.fromUri((URI)this.inputOptions.rootCredentialsOptions.fileOptions.file.toUri());
                realms = rootCredentialsSet.credentials().keySet();
            } else {
                realms = this.inputOptions.rootCredentialsOptions.stdinOptions.realms;
                RootCredentialsSet rootCredentialsSet2 = rootCredentialsSet = this.inputOptions.rootCredentialsOptions.stdinOptions.credentials == null || this.inputOptions.rootCredentialsOptions.stdinOptions.credentials.isEmpty() ? RootCredentialsSet.EMPTY : RootCredentialsSet.fromList(this.inputOptions.rootCredentialsOptions.stdinOptions.credentials);
                if ((this.inputOptions.rootCredentialsOptions.stdinOptions.credentials == null || this.inputOptions.rootCredentialsOptions.stdinOptions.credentials.isEmpty()) && !this.inputOptions.rootCredentialsOptions.stdinOptions.printCredentials) {
                    this.spec.commandLine().getErr().println("Specify either `--credentials` or `--print-credentials` to ensure the root user is accessible after bootstrapping.");
                    return 3;
                }
            }
            if (this.inputOptions.schemaInputOptions != null) {
                ImmutableSchemaOptions.Builder builder = ImmutableSchemaOptions.builder();
                if (this.inputOptions.schemaInputOptions.schemaVersion != null) {
                    builder.schemaVersion(this.inputOptions.schemaInputOptions.schemaVersion.intValue());
                }
                schemaOptions = builder.build();
            } else {
                schemaOptions = ImmutableSchemaOptions.builder().build();
            }
            ImmutableBootstrapOptions bootstrapOptions = ImmutableBootstrapOptions.builder().realms(realms).rootCredentialsSet(rootCredentialsSet).schemaOptions((SchemaOptions)schemaOptions).build();
            Map results = this.metaStoreManagerFactory.bootstrapRealms((BootstrapOptions)bootstrapOptions);
            boolean success = true;
            for (Map.Entry result : results.entrySet()) {
                String realm;
                if (((PrincipalSecretsResult)result.getValue()).isSuccess()) {
                    realm = (String)result.getKey();
                    this.spec.commandLine().getOut().printf("Realm '%s' successfully bootstrapped.%n", realm);
                    if (this.inputOptions.rootCredentialsOptions.stdinOptions == null || !this.inputOptions.rootCredentialsOptions.stdinOptions.printCredentials) continue;
                    String msg = String.format("realm: %1s root principal credentials: %2s:%3s", result.getKey(), ((PrincipalSecretsResult)result.getValue()).getPrincipalSecrets().getPrincipalClientId(), ((PrincipalSecretsResult)result.getValue()).getPrincipalSecrets().getMainSecret());
                    this.spec.commandLine().getOut().println(msg);
                    continue;
                }
                realm = (String)result.getKey();
                this.spec.commandLine().getErr().printf("Bootstrapping '%s' failed: %s%n", realm, ((PrincipalSecretsResult)result.getValue()).getReturnStatus().toString());
                success = false;
            }
            if (success) {
                this.spec.commandLine().getOut().println("Bootstrap completed successfully.");
                return 0;
            }
            this.spec.commandLine().getErr().println("Bootstrap encountered errors during operation.");
            return 3;
        }
        catch (Exception e) {
            e.printStackTrace(this.spec.commandLine().getErr());
            this.spec.commandLine().getErr().println("Bootstrap encountered errors during operation.");
            return 3;
        }
    }

    static class InputOptions {
        @CommandLine.ArgGroup(multiplicity="1")
        RootCredentialsOptions rootCredentialsOptions;
        @CommandLine.Mixin
        SchemaInputOptions schemaInputOptions = new SchemaInputOptions();

        InputOptions() {
        }

        static class SchemaInputOptions {
            @CommandLine.Option(names={"-v", "--schema-version"}, paramLabel="<schema version>", description={"The version of the schema to load in [1, 2, 3, LATEST]."})
            Integer schemaVersion;

            SchemaInputOptions() {
            }
        }

        static class FileInputOptions {
            @CommandLine.Option(names={"-f", "--credentials-file"}, paramLabel="<file>", description={"A file containing root principal credentials to bootstrap."})
            Path file;

            FileInputOptions() {
            }
        }

        static class StandardInputOptions {
            @CommandLine.Option(names={"-r", "--realm"}, paramLabel="<realm>", required=true, description={"The name of a realm to bootstrap."})
            List<String> realms;
            @CommandLine.Option(names={"-c", "--credential"}, paramLabel="<realm,clientId,clientSecret>", description={"Root principal credentials to bootstrap. Must be of the form 'realm,clientId,clientSecret'."})
            List<String> credentials;
            @CommandLine.Option(names={"-p", "--print-credentials"}, description={"Print root credentials to stdout"})
            boolean printCredentials;

            StandardInputOptions() {
            }
        }

        static class RootCredentialsOptions {
            @CommandLine.ArgGroup(exclusive=false, heading="Standard Input Options:%n")
            StandardInputOptions stdinOptions;
            @CommandLine.ArgGroup(exclusive=false, heading="File Input Options:%n")
            FileInputOptions fileOptions;

            RootCredentialsOptions() {
            }
        }
    }
}

