/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import org.apache.iceberg.StructLike;
import org.apache.iceberg.expressions.Bound;
import org.apache.iceberg.expressions.BoundLiteralPredicate;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.BoundSetPredicate;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.expressions.BoundUnaryPredicate;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Predicate;

public abstract class BoundPredicate<T>
extends Predicate<T, BoundTerm<T>>
implements Bound<Boolean> {
    protected BoundPredicate(Expression.Operation op, BoundTerm<T> term) {
        super(op, term);
    }

    public boolean test(StructLike struct) {
        return this.test(((BoundTerm)this.term()).eval(struct));
    }

    public abstract boolean test(T var1);

    @Override
    public Boolean eval(StructLike struct) {
        return this.test(((BoundTerm)this.term()).eval(struct));
    }

    @Override
    public BoundReference<?> ref() {
        return ((BoundTerm)this.term()).ref();
    }

    public boolean isUnaryPredicate() {
        return false;
    }

    public BoundUnaryPredicate<T> asUnaryPredicate() {
        throw new IllegalStateException("Not a unary predicate: " + String.valueOf(this));
    }

    public boolean isLiteralPredicate() {
        return false;
    }

    public BoundLiteralPredicate<T> asLiteralPredicate() {
        throw new IllegalStateException("Not a literal predicate: " + String.valueOf(this));
    }

    public boolean isSetPredicate() {
        return false;
    }

    public BoundSetPredicate<T> asSetPredicate() {
        throw new IllegalStateException("Not a set predicate: " + String.valueOf(this));
    }
}

