/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import picocli.CommandLine;

@CommandLine.Command(description={"Operations about tenants"})
public class CmdTenants
extends CmdBase {
    public CmdTenants(Supplier<PulsarAdmin> admin) {
        super("tenants", admin);
        this.addCommand("list", new List());
        this.addCommand("get", new Get());
        this.addCommand("create", new Create());
        this.addCommand("update", new Update());
        this.addCommand("delete", new Delete());
    }

    @CommandLine.Command(description={"List the existing tenants"})
    private class List
    extends CliCommand {
        private List() {
        }

        @Override
        void run() throws PulsarAdminException {
            this.print(CmdTenants.this.getAdmin().tenants().getTenants());
        }
    }

    @CommandLine.Command(description={"Gets the configuration of a tenant"})
    private class Get
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant-name"}, arity="1")
        private String tenant;

        private Get() {
        }

        @Override
        void run() throws PulsarAdminException {
            this.print(CmdTenants.this.getAdmin().tenants().getTenantInfo(this.tenant));
        }
    }

    @CommandLine.Command(description={"Creates a new tenant"})
    private class Create
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant-name"}, arity="1")
        private String tenant;
        @CommandLine.Option(names={"--admin-roles", "-r"}, description={"Comma separated list of auth principal allowed to administrate the tenant"}, required=false, split=",")
        private java.util.List<String> adminRoles;
        @CommandLine.Option(names={"--allowed-clusters", "-c"}, description={"Comma separated allowed clusters. If empty, the tenant will have access to all clusters"}, required=false, split=",")
        private java.util.List<String> allowedClusters;

        private Create() {
        }

        @Override
        void run() throws PulsarAdminException {
            if (this.adminRoles == null) {
                this.adminRoles = Collections.emptyList();
            }
            if (this.allowedClusters == null || this.allowedClusters.isEmpty()) {
                this.allowedClusters = CmdTenants.this.getAdmin().clusters().getClusters();
            }
            TenantInfoImpl tenantInfo = new TenantInfoImpl(new HashSet<String>(this.adminRoles), new HashSet<String>(this.allowedClusters));
            CmdTenants.this.getAdmin().tenants().createTenant(this.tenant, (TenantInfo)tenantInfo);
        }
    }

    @CommandLine.Command(description={"Updates the configuration for a tenant"})
    private class Update
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant-name"}, arity="1")
        private String tenant;
        @CommandLine.Option(names={"--admin-roles", "-r"}, description={"Comma separated list of auth principal allowed to administrate the tenant. If empty the current set of roles won't be modified"}, required=false, split=",")
        private java.util.List<String> adminRoles;
        @CommandLine.Option(names={"--allowed-clusters", "-c"}, description={"Comma separated allowed clusters. If omitted, the current set of clusters will be preserved"}, required=false, split=",")
        private java.util.List<String> allowedClusters;

        private Update() {
        }

        @Override
        void run() throws PulsarAdminException {
            if (this.adminRoles == null) {
                this.adminRoles = new ArrayList<String>(CmdTenants.this.getAdmin().tenants().getTenantInfo(this.tenant).getAdminRoles());
            }
            if (this.allowedClusters == null) {
                this.allowedClusters = new ArrayList<String>(CmdTenants.this.getAdmin().tenants().getTenantInfo(this.tenant).getAllowedClusters());
            }
            TenantInfoImpl tenantInfo = new TenantInfoImpl(new HashSet<String>(this.adminRoles), new HashSet<String>(this.allowedClusters));
            CmdTenants.this.getAdmin().tenants().updateTenant(this.tenant, (TenantInfo)tenantInfo);
        }
    }

    @CommandLine.Command(description={"Deletes an existing tenant"})
    private class Delete
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant-name"}, arity="1")
        private String tenant;
        @CommandLine.Option(names={"-f", "--force"}, description={"Delete a tenant forcefully by deleting all namespaces under it."})
        private boolean force = false;

        private Delete() {
        }

        @Override
        void run() throws PulsarAdminException {
            CmdTenants.this.getAdmin().tenants().deleteTenant(this.tenant, this.force);
        }
    }

    @CommandLine.Command(hidden=true)
    static class CmdProperties
    extends CmdTenants {
        public CmdProperties(Supplier<PulsarAdmin> admin) {
            super(admin);
        }
    }
}

