/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.tree.BIN;

public class StorageSize {
    private static final int LN_OVERHEAD = 50;
    private static final int SEC_SLOT_OVERHEAD = 12;
    private static final int PRI_SLOT_OVERHEAD = 14;
    private static final int PRI_EMBEDDED_LN_SLOT_OVERHEAD = 20;

    private StorageSize() {
    }

    public static int getStorageSize(BIN bin, int idx) {
        int storedKeySize = bin.getStoredKeySize(idx);
        if (bin.getDatabase().getSortedDuplicates()) {
            return storedKeySize - 1 + 12;
        }
        if (bin.isEmbeddedLN(idx)) {
            return storedKeySize - 1 + 20;
        }
        int lastLoggedSize = bin.getLastLoggedSize(idx);
        if (lastLoggedSize == 0) {
            return 0;
        }
        return lastLoggedSize + storedKeySize + 14;
    }
}

