/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.latency;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.common.BrokerIdentity;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.future.FutureTaskExt;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.netty.RequestTask;

public class BrokerFastFailure {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final ScheduledExecutorService scheduledExecutorService;
    private final BrokerController brokerController;
    private volatile long jstackTime = System.currentTimeMillis();
    private final List<Pair<BlockingQueue<Runnable>, Supplier<Long>>> cleanExpiredRequestQueueList = new ArrayList<Pair<BlockingQueue<Runnable>, Supplier<Long>>>();

    public BrokerFastFailure(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.initCleanExpiredRequestQueueList();
        this.scheduledExecutorService = ThreadUtils.newScheduledThreadPool((int)1, (ThreadFactory)new ThreadFactoryImpl("BrokerFastFailureScheduledThread", true, (BrokerIdentity)(brokerController == null ? null : brokerController.getBrokerConfig())));
    }

    private void initCleanExpiredRequestQueueList() {
        this.cleanExpiredRequestQueueList.add((Pair<BlockingQueue<Runnable>, Supplier<Long>>)new Pair(this.brokerController.getSendThreadPoolQueue(), () -> this.brokerController.getBrokerConfig().getWaitTimeMillsInSendQueue()));
        this.cleanExpiredRequestQueueList.add((Pair<BlockingQueue<Runnable>, Supplier<Long>>)new Pair(this.brokerController.getPullThreadPoolQueue(), () -> this.brokerController.getBrokerConfig().getWaitTimeMillsInPullQueue()));
        this.cleanExpiredRequestQueueList.add((Pair<BlockingQueue<Runnable>, Supplier<Long>>)new Pair(this.brokerController.getLitePullThreadPoolQueue(), () -> this.brokerController.getBrokerConfig().getWaitTimeMillsInLitePullQueue()));
        this.cleanExpiredRequestQueueList.add((Pair<BlockingQueue<Runnable>, Supplier<Long>>)new Pair(this.brokerController.getHeartbeatThreadPoolQueue(), () -> this.brokerController.getBrokerConfig().getWaitTimeMillsInHeartbeatQueue()));
        this.cleanExpiredRequestQueueList.add((Pair<BlockingQueue<Runnable>, Supplier<Long>>)new Pair(this.brokerController.getEndTransactionThreadPoolQueue(), () -> this.brokerController.getBrokerConfig().getWaitTimeMillsInTransactionQueue()));
        this.cleanExpiredRequestQueueList.add((Pair<BlockingQueue<Runnable>, Supplier<Long>>)new Pair(this.brokerController.getAckThreadPoolQueue(), () -> this.brokerController.getBrokerConfig().getWaitTimeMillsInAckQueue()));
        this.cleanExpiredRequestQueueList.add((Pair<BlockingQueue<Runnable>, Supplier<Long>>)new Pair(this.brokerController.getAdminBrokerThreadPoolQueue(), () -> this.brokerController.getBrokerConfig().getWaitTimeMillsInAdminBrokerQueue()));
    }

    public static RequestTask castRunnable(Runnable runnable) {
        try {
            if (runnable instanceof FutureTaskExt) {
                FutureTaskExt object = (FutureTaskExt)runnable;
                return (RequestTask)object.getRunnable();
            }
        }
        catch (Throwable e) {
            LOGGER.error(String.format("castRunnable exception, %s", runnable.getClass().getName()), e);
        }
        return null;
    }

    public void start() {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (BrokerFastFailure.this.brokerController.getBrokerConfig().isBrokerFastFailureEnable()) {
                    BrokerFastFailure.this.cleanExpiredRequest();
                }
            }
        }, 1000L, 10L, TimeUnit.MILLISECONDS);
    }

    private void cleanExpiredRequest() {
        while (this.brokerController.getMessageStore().isOSPageCacheBusy()) {
            try {
                Runnable runnable;
                if (this.brokerController.getSendThreadPoolQueue().isEmpty() || null == (runnable = this.brokerController.getSendThreadPoolQueue().poll(0L, TimeUnit.SECONDS))) break;
                RequestTask rt = BrokerFastFailure.castRunnable(runnable);
                if (rt == null) continue;
                rt.returnResponse(2, String.format("[PCBUSY_CLEAN_QUEUE]broker busy, start flow control for a while, period in queue: %sms, size of queue: %d", System.currentTimeMillis() - rt.getCreateTimestamp(), this.brokerController.getSendThreadPoolQueue().size()));
            }
            catch (Throwable throwable) {}
        }
        for (Pair<BlockingQueue<Runnable>, Supplier<Long>> pair : this.cleanExpiredRequestQueueList) {
            this.cleanExpiredRequestInQueue((BlockingQueue)pair.getObject1(), (Long)((Supplier)pair.getObject2()).get());
        }
    }

    void cleanExpiredRequestInQueue(BlockingQueue<Runnable> blockingQueue, long maxWaitTimeMillsInQueue) {
        while (true) {
            try {
                long behind;
                RequestTask rt;
                Runnable runnable;
                while (!blockingQueue.isEmpty() && null != (runnable = (Runnable)blockingQueue.peek()) && (rt = BrokerFastFailure.castRunnable(runnable)) != null && !rt.isStopRun() && (behind = System.currentTimeMillis() - rt.getCreateTimestamp()) >= maxWaitTimeMillsInQueue) {
                    if (!blockingQueue.remove(runnable)) continue;
                    rt.setStopRun(true);
                    rt.returnResponse(2, String.format("[TIMEOUT_CLEAN_QUEUE]broker busy, start flow control for a while, period in queue: %sms, size of queue: %d", behind, blockingQueue.size()));
                    if (System.currentTimeMillis() - this.jstackTime <= 15000L) continue;
                    this.jstackTime = System.currentTimeMillis();
                    LOGGER.warn("broker jstack \n " + UtilAll.jstack());
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    public synchronized void addCleanExpiredRequestQueue(BlockingQueue<Runnable> cleanExpiredRequestQueue, Supplier<Long> maxWaitTimeMillsInQueueSupplier) {
        this.cleanExpiredRequestQueueList.add((Pair<BlockingQueue<Runnable>, Supplier<Long>>)new Pair(cleanExpiredRequestQueue, maxWaitTimeMillsInQueueSupplier));
    }

    public void shutdown() {
        this.scheduledExecutorService.shutdown();
    }
}

