/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.auth;

import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.CommandUtil;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class UpdateUserSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "updateUser";
    }

    @Override
    public String commandDesc() {
        return "Update user to cluster.";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        OptionGroup optionGroup = new OptionGroup();
        Option opt = new Option("c", "clusterName", true, "update user to which cluster");
        optionGroup.addOption(opt);
        opt = new Option("b", "brokerAddr", true, "update user to which broker");
        optionGroup.addOption(opt);
        optionGroup.setRequired(true);
        options.addOptionGroup(optionGroup);
        opt = new Option("u", "username", true, "the username of user to update.");
        opt.setRequired(true);
        options.addOption(opt);
        optionGroup = new OptionGroup();
        opt = new Option("p", "password", true, "the password of user to update");
        optionGroup.addOption(opt);
        opt = new Option("t", "userType", true, "the userType of user to update");
        optionGroup.addOption(opt);
        opt = new Option("s", "userStatus", true, "the userStatus of user to update");
        optionGroup.addOption(opt);
        optionGroup.setRequired(true);
        options.addOptionGroup(optionGroup);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            String username = StringUtils.trim((String)commandLine.getOptionValue('u'));
            String password = StringUtils.trim((String)commandLine.getOptionValue('p'));
            String userType = StringUtils.trim((String)commandLine.getOptionValue('t'));
            String userStatus = StringUtils.trim((String)commandLine.getOptionValue('s'));
            if (commandLine.hasOption('b')) {
                String addr = commandLine.getOptionValue('b').trim();
                defaultMQAdminExt.start();
                defaultMQAdminExt.updateUser(addr, username, password, userType, userStatus);
                System.out.printf("update user to %s success.%n", addr);
                return;
            }
            if (commandLine.hasOption('c')) {
                String clusterName = commandLine.getOptionValue('c').trim();
                defaultMQAdminExt.start();
                Set<String> brokerAddrSet = CommandUtil.fetchMasterAndSlaveAddrByClusterName(defaultMQAdminExt, clusterName);
                for (String addr : brokerAddrSet) {
                    defaultMQAdminExt.updateUser(addr, username, password, userType, userStatus);
                    System.out.printf("update user to %s success.%n", addr);
                }
                return;
            }
            ServerUtil.printCommandLineHelp((String)("mqadmin " + this.commandName()), (Options)options);
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }
}

