/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.rpc;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.rocketmq.client.java.rpc.Context;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.Futures;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.ListenableFuture;

public class RpcFuture<R, T>
implements ListenableFuture<T> {
    private final R request;
    private final Context context;
    private final ListenableFuture<T> responseFuture;

    public RpcFuture(Context context, R request, ListenableFuture<T> responseFuture) {
        this.request = request;
        this.context = context;
        this.responseFuture = responseFuture;
    }

    public RpcFuture(Throwable t2) {
        this.request = null;
        this.context = null;
        this.responseFuture = Futures.immediateFailedFuture(t2);
    }

    public R getRequest() {
        return this.request;
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public void addListener(Runnable listener, Executor executor) {
        this.responseFuture.addListener(listener, executor);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.responseFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.responseFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.responseFuture.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return (T)this.responseFuture.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.responseFuture.get(timeout, unit);
    }
}

