/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import javax.imageio.stream.ImageInputStream;
import org.apache.sis.io.InvalidSeekException;
import org.apache.sis.io.stream.Markable;
import org.apache.sis.storage.internal.Resources;

public final class InputStreamAdapter
extends InputStream
implements Markable {
    public final ImageInputStream input;
    private long markPosition;
    private int markIndex;
    private int nestedMarks;
    boolean keepOpen;

    public InputStreamAdapter(ImageInputStream input) throws IOException {
        assert (!(input instanceof InputStream));
        this.input = input;
        this.markIndex = -1;
    }

    @Override
    public int read() throws IOException {
        return this.input.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.input.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.input.read(b, off, len);
    }

    @Override
    public byte[] readNBytes(int count) throws IOException {
        long length = this.input.length();
        if (length < 0L) {
            return super.readNBytes(count);
        }
        count = (int)Math.min((long)count, Math.subtractExact(length, this.input.getStreamPosition()));
        byte[] array = new byte[count];
        this.input.readFully(array);
        return array;
    }

    @Override
    public int readNBytes(byte[] array, int offset, int count) throws IOException {
        long length = this.input.length();
        if (length < 0L) {
            return super.readNBytes(array, offset, count);
        }
        count = (int)Math.min((long)count, Math.subtractExact(length, this.input.getStreamPosition()));
        this.input.readFully(array, offset, count);
        return count;
    }

    @Override
    public void skipNBytes(long count) throws IOException {
        this.input.seek(Math.addExact(this.input.getStreamPosition(), count));
    }

    @Override
    public long skip(long n) throws IOException {
        return this.input.skipBytes(n);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.markPosition = this.input.getStreamPosition();
            if (this.nestedMarks == 0) {
                this.input.flushBefore(this.markPosition);
            }
            this.markIndex = this.nestedMarks;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public synchronized void mark() {
        this.input.mark();
        ++this.nestedMarks;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.markIndex == this.nestedMarks) {
            if (this.markIndex != 0) {
                this.markIndex = -1;
            }
            this.input.seek(this.markPosition);
        } else if (this.nestedMarks > 0) {
            --this.nestedMarks;
            this.input.reset();
        } else {
            throw new IOException(Resources.format((short)63));
        }
    }

    @Override
    public synchronized void reset(long mark) throws IOException {
        int n;
        long p;
        do {
            n = this.nestedMarks;
            this.reset();
        } while ((p = this.input.getStreamPosition()) > mark && n > 0);
        if (p != mark) {
            throw new InvalidSeekException();
        }
    }

    @Override
    public long getStreamPosition() throws IOException {
        return this.input.getStreamPosition();
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.keepOpen) {
            this.input.close();
        }
    }
}

