/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind;

import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.sis.math.NumberType;

public final class FinalClassExtensions {
    private static final Map<Object, Object> SENTINEL_VALUES = new IdentityHashMap<Object, Object>();

    private FinalClassExtensions() {
    }

    private static boolean isValidKey(Class<?> type) {
        return Modifier.isFinal(type.getModifiers()) && !type.isPrimitive() && !NumberType.forClass(type).orElse(NumberType.NULL).isConvertible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void associate(Object instance, Object property) {
        assert (FinalClassExtensions.isValidKey(instance.getClass())) : instance;
        Map<Object, Object> map = SENTINEL_VALUES;
        synchronized (map) {
            Object old = SENTINEL_VALUES.put(instance, property);
            if (old != null) {
                SENTINEL_VALUES.put(instance, old);
                throw new AssertionError(instance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object property(Object instance) {
        Map<Object, Object> map = SENTINEL_VALUES;
        synchronized (map) {
            return SENTINEL_VALUES.get(instance);
        }
    }
}

