/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Collections;
import java.util.Iterator;
import javax.inject.Inject;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.injectors.RequestAttributeInjector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ParameterizedTypeFromRequestAttributeTest {
    private ModelAdapterFactory factory;
    @Mock
    private SlingJakartaHttpServletRequest request;

    ParameterizedTypeFromRequestAttributeTest() {
    }

    @BeforeEach
    void setup() {
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        RequestAttributeInjector injector = new RequestAttributeInjector();
        this.factory.injectors = Collections.singletonList(injector);
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{TestModel.class});
    }

    @Test
    void test() {
        Iterator it = Collections.emptySet().iterator();
        Mockito.when((Object)this.request.getAttribute("someResources")).thenReturn(it);
        TestModel model = (TestModel)this.factory.getAdapter((Object)this.request, TestModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals(it, model.getSomeResources());
    }

    @Model(adaptables={SlingJakartaHttpServletRequest.class})
    static class TestModel {
        @Inject
        private Iterator<Resource> someResources;

        TestModel() {
        }

        public Iterator<Resource> getSomeResources() {
            return this.someResources;
        }
    }
}

