/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.ServicePropertiesMap;
import org.apache.sling.models.impl.injectors.ResourcePathInjector;
import org.apache.sling.models.impl.injectors.SelfInjector;
import org.apache.sling.models.impl.injectors.ValueMapInjector;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;
import org.apache.sling.models.testmodels.classes.ResourcePathAllOptionalModel;
import org.apache.sling.models.testmodels.classes.ResourcePathModel;
import org.apache.sling.models.testmodels.classes.ResourcePathModelWrapping;
import org.apache.sling.models.testmodels.classes.ResourcePathPartialModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ResourcePathInjectionTest {
    private ModelAdapterFactory factory;
    @Mock
    private Resource adaptableResource;
    @Mock
    SlingJakartaHttpServletRequest adaptableRequest;
    @Mock
    private Resource byPathResource;
    @Mock
    private Resource byPathResource2;
    @Mock
    private Resource byPropertyValueResource;
    @Mock
    private Resource byPropertyValueResource2;
    @Mock
    private ResourceResolver resourceResolver;

    ResourcePathInjectionTest() {
    }

    @BeforeEach
    void setup() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("propertyContainingAPath", "/some/other/path");
        map.put("anotherPropertyContainingAPath", "/some/other/path2");
        String[] paths = new String[]{"/some/other/path", "/some/other/path2"};
        String[] invalidPaths = new String[]{"/does/not/exist", "/does/not/exist2", "/some/other/path"};
        map.put("propertyWithSeveralPaths", paths);
        map.put("propertyWithMissingPaths", invalidPaths);
        ValueMapDecorator properties = new ValueMapDecorator(map);
        Mockito.lenient().when((Object)this.adaptableResource.getResourceResolver()).thenReturn((Object)this.resourceResolver);
        Mockito.lenient().when((Object)((ValueMap)this.adaptableResource.adaptTo(ValueMap.class))).thenReturn((Object)properties);
        Mockito.lenient().when((Object)this.resourceResolver.getResource("/some/path")).thenReturn((Object)this.byPathResource);
        Mockito.lenient().when((Object)this.resourceResolver.getResource("/some/path2")).thenReturn((Object)this.byPathResource2);
        Mockito.lenient().when((Object)this.resourceResolver.getResource("/some/other/path")).thenReturn((Object)this.byPropertyValueResource);
        Mockito.lenient().when((Object)this.resourceResolver.getResource("/some/other/path2")).thenReturn((Object)this.byPropertyValueResource2);
        Mockito.lenient().when((Object)this.adaptableRequest.getResource()).thenReturn((Object)this.byPathResource);
        Mockito.lenient().when((Object)this.adaptableRequest.getResourceResolver()).thenReturn((Object)this.resourceResolver);
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        this.factory.injectors = Arrays.asList(new SelfInjector(), new ValueMapInjector(), new ResourcePathInjector());
        this.factory.bindStaticInjectAnnotationProcessorFactory((StaticInjectAnnotationProcessorFactory)new ResourcePathInjector(), (Map)new ServicePropertiesMap(3L, 2500));
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{ResourcePathModel.class, ResourcePathPartialModel.class, ResourcePathAllOptionalModel.class, ResourcePathModelWrapping.class});
    }

    @Test
    void testPathInjectionFromResource() {
        ResourcePathModel model = (ResourcePathModel)this.factory.getAdapter((Object)this.adaptableResource, ResourcePathModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)this.byPathResource, (Object)model.getFromPath());
        Assertions.assertEquals((Object)this.byPropertyValueResource, (Object)model.getByDerefProperty());
        Assertions.assertEquals((Object)this.byPathResource2, (Object)model.getFromPath2());
        Assertions.assertEquals((Object)this.byPropertyValueResource2, (Object)model.getByDerefProperty2());
    }

    @Test
    void testPathInjectionFromRequest() {
        ((Resource)Mockito.doReturn((Object)this.adaptableResource.adaptTo(ValueMap.class)).when((Object)this.byPathResource)).adaptTo(ValueMap.class);
        ResourcePathModel model = (ResourcePathModel)this.factory.getAdapter((Object)this.adaptableRequest, ResourcePathModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)this.byPathResource, (Object)model.getFromPath());
        Assertions.assertEquals((Object)this.byPropertyValueResource, (Object)model.getByDerefProperty());
        Assertions.assertEquals((Object)this.byPathResource2, (Object)model.getFromPath2());
        Assertions.assertEquals((Object)this.byPropertyValueResource2, (Object)model.getByDerefProperty2());
    }

    @Test
    void testOptionalPathInjectionWithNonResourceAdaptable() {
        ResourcePathAllOptionalModel model = (ResourcePathAllOptionalModel)this.factory.getAdapter((Object)this.adaptableRequest, ResourcePathAllOptionalModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertNull((Object)model.getFromPath());
        Assertions.assertNull((Object)model.getByDerefProperty());
        Assertions.assertNull((Object)model.getFromPath2());
        Assertions.assertNull((Object)model.getByDerefProperty2());
    }

    @Test
    void testMultiplePathInjection() {
        ResourcePathModel model = (ResourcePathModel)this.factory.getAdapter((Object)this.adaptableResource, ResourcePathModel.class);
        Assertions.assertNotNull((Object)model);
        List<Resource> resources = model.getMultipleResources();
        Assertions.assertNotNull(resources);
        Assertions.assertEquals((int)2, (int)resources.size());
        Assertions.assertEquals((Object)this.byPropertyValueResource, (Object)resources.get(0));
        Assertions.assertEquals((Object)this.byPropertyValueResource2, (Object)resources.get(1));
        List<Resource> resourcesFromPathAnnotation = model.getManyFromPath();
        Assertions.assertNotNull(resourcesFromPathAnnotation);
        Assertions.assertEquals((Object)this.byPathResource, (Object)resourcesFromPathAnnotation.get(0));
        Assertions.assertEquals((Object)this.byPathResource2, (Object)resourcesFromPathAnnotation.get(1));
        List<Resource> resourcesFromResourcePathAnnotation = model.getManyFromPath2();
        Assertions.assertNotNull(resourcesFromResourcePathAnnotation);
        Assertions.assertEquals((Object)this.byPathResource2, (Object)resourcesFromResourcePathAnnotation.get(0));
        Assertions.assertEquals((Object)this.byPathResource, (Object)resourcesFromResourcePathAnnotation.get(1));
        Assertions.assertNotNull(model.getPropertyWithSeveralPaths());
        Assertions.assertEquals((Object)this.byPropertyValueResource, (Object)model.getPropertyWithSeveralPaths().get(0));
        Assertions.assertEquals((Object)this.byPropertyValueResource2, (Object)model.getPropertyWithSeveralPaths().get(1));
    }

    @Test
    void testPartialInjectionFailure1() {
        Mockito.when((Object)this.resourceResolver.getResource("/some/other/path")).thenReturn(null);
        ResourcePathPartialModel model = (ResourcePathPartialModel)this.factory.getAdapter((Object)this.adaptableResource, ResourcePathPartialModel.class);
        Assertions.assertNull((Object)model);
    }

    @Test
    void testPartialInjectionFailure2() {
        Mockito.lenient().when((Object)this.resourceResolver.getResource("/some/other/path")).thenReturn(null);
        Mockito.lenient().when((Object)this.resourceResolver.getResource("/some/other/path2")).thenReturn(null);
        ResourcePathPartialModel model = (ResourcePathPartialModel)this.factory.getAdapter((Object)this.adaptableResource, ResourcePathPartialModel.class);
        Assertions.assertNull((Object)model);
    }

    @Test
    void TestWithArrayWrapping() {
        ResourcePathModelWrapping model = (ResourcePathModelWrapping)this.factory.getAdapter((Object)this.adaptableResource, ResourcePathModelWrapping.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertTrue((model.getFromPath().length > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((model.getMultipleResources().length > 0 ? 1 : 0) != 0);
    }
}

