/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.catalina.users;


import org.apache.catalina.UserDatabase;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.security.Escape;

/**
 * <p>
 * Concrete implementation of {@link org.apache.catalina.Group} for the {@link MemoryUserDatabase} implementation of
 * {@link UserDatabase}.
 * </p>
 *
 * @since 4.1
 *
 * @deprecated Use {@link GenericGroup} instead.
 */
@Deprecated
public class MemoryGroup extends GenericGroup<MemoryUserDatabase> {


    /**
     * Package-private constructor used by the factory method in {@link MemoryUserDatabase}.
     *
     * @param database    The {@link MemoryUserDatabase} that owns this group
     * @param groupname   Group name of this group
     * @param description Description of this group
     */
    MemoryGroup(MemoryUserDatabase database, String groupname, String description) {
        super(database, groupname, description, null);
    }


    /**
     * <p>
     * Return a String representation of this group in XML format.
     * </p>
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("<group groupname=\"");
        sb.append(Escape.xml(groupname));
        sb.append("\"");
        if (description != null) {
            sb.append(" description=\"");
            sb.append(Escape.xml(description));
            sb.append("\"");
        }
        sb.append(" roles=\"");
        StringBuilder rsb = new StringBuilder();
        StringUtils.join(roles, ',', (x) -> Escape.xml(x.getRolename()), rsb);
        sb.append(rsb);
        sb.append("\"");
        sb.append("/>");
        return sb.toString();
    }
}
