/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.webservices;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.server.httpd.ServletRequestAdapter;
import org.apache.openejb.server.httpd.ServletResponseAdapter;

public class WsServlet
implements Servlet {
    public static final String WEBSERVICE_CONTAINER = WsServlet.class.getName() + "@WebServiceContainer";
    private ServletConfig config;
    private HttpListener service;

    public WsServlet() {
    }

    public WsServlet(HttpListener service) {
        this.service = service;
    }

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        this.getService();
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public String getServletInfo() {
        return "Webservice Servlet " + String.valueOf(this.getService());
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpListener service = this.getService();
        if (service == null) {
            throw new ServletException("WebServiceContainer has not been set");
        }
        res.setContentType("text/xml");
        ServletRequestAdapter httpRequest = new ServletRequestAdapter((HttpServletRequest)req, (HttpServletResponse)res, this.config.getServletContext());
        ServletResponseAdapter httpResponse = new ServletResponseAdapter((HttpServletResponse)res);
        try {
            service.onMessage((HttpRequest)httpRequest, (HttpResponse)httpResponse);
        }
        catch (ServletException | IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException("Error processing webservice request", (Throwable)e);
        }
    }

    public void destroy() {
    }

    private synchronized HttpListener getService() {
        ServletConfig config;
        String webServiceContainerId;
        if (this.service == null && (webServiceContainerId = (config = this.getServletConfig()).getInitParameter(WEBSERVICE_CONTAINER)) != null) {
            this.service = (HttpListener)config.getServletContext().getAttribute(webServiceContainerId);
        }
        return this.service;
    }
}

