/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.util.EnumSet;

public enum CallbackMode {
    FAIL_FAST(2),
    IGNORE(4),
    LOG(8),
    RETHROW(16),
    ROLLBACK(32);

    private final int callbackMode;

    private CallbackMode(int value) {
        this.callbackMode = value;
    }

    static EnumSet<CallbackMode> toEnumSet(int callback) {
        EnumSet<CallbackMode> modes = EnumSet.noneOf(CallbackMode.class);
        if ((callback & 2) != 0) {
            modes.add(FAIL_FAST);
        }
        if ((callback & 4) != 0) {
            modes.add(IGNORE);
        }
        if ((callback & 8) != 0) {
            modes.add(LOG);
        }
        if ((callback & 0x10) != 0) {
            modes.add(RETHROW);
        }
        if ((callback & 0x20) != 0) {
            modes.add(ROLLBACK);
        }
        return modes;
    }

    static int fromEnumSet(EnumSet<CallbackMode> modes) {
        int callback = 0;
        for (CallbackMode mode : modes) {
            callback |= mode.callbackMode;
        }
        return callback;
    }
}

