/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.service;

import jakarta.enterprise.inject.spi.Extension;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.LoaderService;
import org.apache.webbeans.util.WebBeansUtil;

public class DefaultLoaderService
implements LoaderService {
    public <T> List<T> load(Class<T> serviceType) {
        return this.load(serviceType, WebBeansUtil.getCurrentClassLoader());
    }

    public <T> List<T> load(Class<T> serviceType, ClassLoader classLoader) {
        try {
            Stream stream = StreamSupport.stream(ServiceLoader.load(serviceType, classLoader).spliterator(), false);
            if (Extension.class == serviceType) {
                return this.mapExtensions(stream).collect(Collectors.toList());
            }
            return stream.collect(Collectors.toList());
        }
        catch (Error error) {
            WebBeansLoggerFacade.getLogger(DefaultLoaderService.class).log(Level.SEVERE, "Problem while loading CDI Extensions", error);
            throw new WebBeansConfigurationException("Problem while loading CDI Extensions", error);
        }
    }

    protected <T> Stream<T> mapExtensions(Stream<T> stream) {
        return stream;
    }
}

