/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.axiom.ts.dom.element;

import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.axiom.ts.dom.DOMTestCase;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * Tests the behavior of {@link Node#replaceChild(Node, Node)} if an attempt is made to replace a
 * child with an ancestor of the node, i.e. if the replacement would create a cycle.
 */
public class TestReplaceChildCyclic extends DOMTestCase {
    public TestReplaceChildCyclic(DocumentBuilderFactory dbf) {
        super(dbf);
    }

    @Override
    protected void runTest() throws Throwable {
        Document document = dbf.newDocumentBuilder().newDocument();
        Element ancestor = document.createElementNS(null, "ancestor");
        Element element = document.createElementNS(null, "element");
        ancestor.appendChild(element);
        Element child = document.createElementNS(null, "child");
        element.appendChild(child);
        try {
            element.replaceChild(ancestor, child);
            fail("Expected DOMException");
        } catch (DOMException ex) {
            assertEquals(DOMException.HIERARCHY_REQUEST_ERR, ex.code);
        }
    }
}
